/*
 * Decompiled with CFR 0.152.
 */
package com.rabbit.blade.domain.operator;

import com.rabbit.blade.comm.exeption.CheckException;
import com.rabbit.blade.domain.operator.VerifyResult;
import rx.Observable;
import rx.Producer;
import rx.Subscriber;
import rx.exceptions.Exceptions;
import rx.exceptions.OnErrorThrowable;
import rx.functions.Func1;
import rx.internal.util.RxJavaPluginUtils;

public class OperatorVerify<T, E extends RuntimeException>
implements Observable.Operator<T, T> {
    private final Func1<T, VerifyResult<E>> verifyResultFunc1;

    public OperatorVerify(Func1<T, VerifyResult<E>> verifyResultFunc1) {
        this.verifyResultFunc1 = verifyResultFunc1;
    }

    public Subscriber<? super T> call(Subscriber<? super T> subscriber) {
        VerifySubscriber<? super T, E> parent = new VerifySubscriber<T, E>(subscriber, this.verifyResultFunc1);
        subscriber.add(parent);
        return parent;
    }

    static final class VerifySubscriber<T, E1 extends RuntimeException>
    extends Subscriber<T> {
        final Subscriber<? super T> actual;
        private final Func1<T, VerifyResult<E1>> verifyResultFunc1;
        boolean done;

        protected VerifySubscriber(Subscriber<? super T> actual, Func1<T, VerifyResult<E1>> verifyResultFunc1) {
            this.actual = actual;
            this.verifyResultFunc1 = verifyResultFunc1;
        }

        public void onNext(T t) {
            try {
                VerifyResult result = (VerifyResult)this.verifyResultFunc1.call(t);
                if (result != null && !result.isVerify()) {
                    Object exception = result.getException();
                    if (exception != null) {
                        Exceptions.throwIfFatal(exception);
                        this.unsubscribe();
                        this.onError(OnErrorThrowable.addValueAsLastCause(exception, t));
                    } else {
                        CheckException ce = new CheckException("\u672a\u77e5\u7684\u6821\u9a8c\u5f02\u5e38", "parms_notValid");
                        Exceptions.throwIfFatal((Throwable)ce);
                        this.unsubscribe();
                        this.onError(OnErrorThrowable.addValueAsLastCause((Throwable)ce, t));
                    }
                    return;
                }
            }
            catch (Throwable ex) {
                Exceptions.throwIfFatal((Throwable)ex);
                this.unsubscribe();
                this.onError(OnErrorThrowable.addValueAsLastCause((Throwable)ex, t));
                return;
            }
            this.actual.onNext(t);
        }

        public void onError(Throwable e) {
            if (this.done) {
                RxJavaPluginUtils.handleException((Throwable)e);
                return;
            }
            this.done = true;
            this.actual.onError(e);
        }

        public void onCompleted() {
            if (this.done) {
                return;
            }
            this.actual.onCompleted();
        }

        public void setProducer(Producer p) {
            this.actual.setProducer(p);
        }
    }
}

