/*
 * Decompiled with CFR 0.152.
 */
package com.rabbit.blade.domain.test;

import com.rabbit.blade.domain.event.AgentMessage;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import junit.framework.Assert;
import rx.functions.Action1;

public class TestMessageAction
implements Action1<AgentMessage<?>> {
    private final CountDownLatch latch = new CountDownLatch(1);
    private final List<AgentMessage<?>> agentMessages = new ArrayList(3);
    private int messageCount;

    public void await(long timeout, int expectedMsgCount) {
        try {
            this.messageCount = expectedMsgCount;
            this.latch.await(timeout, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    public void await(int expectedMsgCount) {
        this.await(3600000L, expectedMsgCount);
    }

    public void call(AgentMessage<?> agentMessage) {
        this.agentMessages.add(agentMessage);
        if (this.agentMessages.size() >= this.messageCount) {
            this.latch.countDown();
        }
    }

    public void assertValueCount(int messageCount) {
        Assert.assertEquals((int)this.agentMessages.size(), (int)messageCount);
    }

    public void assertValueContent(AgentMessage<?> agentMessage) {
        int size = this.agentMessages.size();
        Assert.assertEquals((int)size, (int)1);
        AgentMessage<?> am = this.agentMessages.get(0);
        Assert.assertEquals(am.getObject(), agentMessage.getObject());
        Assert.assertEquals((int)am.getWhat(), (int)agentMessage.getWhat());
    }

    public void assertValuesContent(AgentMessage<?> ... agentMessages) {
        int length = agentMessages.length;
        int size = this.agentMessages.size();
        Assert.assertEquals((int)length, (int)size);
        for (int index = 0; index < agentMessages.length; ++index) {
            AgentMessage<?> am = agentMessages[index];
            AgentMessage<?> agentMessage = this.agentMessages.get(index);
            Assert.assertEquals(am.getObject(), agentMessage.getObject());
            Assert.assertEquals((int)am.getWhat(), (int)agentMessage.getWhat());
        }
    }
}

