package com.rabbit.blade.domain.event;

import android.support.annotation.NonNull;

import com.rabbit.blade.comm.event.BusProvider;


/**
 * <b>Description : 领域事件总线</b>
 * <p>Created by <a href="mailto:fanjiandong@outlook.com">fanjiandong</a> on 2016/12/27 23:12.</p>
 */

public class DomainEventProvider {

    private static DomainEventProvider eventProvider;

    public static DomainEventProvider instance() {
        if (eventProvider == null) {
            synchronized (DomainEventProvider.class) {
                if (eventProvider == null) {
                    eventProvider = new DomainEventProvider();
                }
            }
        }
        return eventProvider;
    }

    private final BusProvider evnetBus;

    private DomainEventProvider() {
        this.evnetBus = new BusProvider();
    }

    /**
     * 发布时间
     *
     * @param event 事件源
     * @param <T>   事件源类型定义
     */
    public <T> void publish(@NonNull T event) {
        evnetBus.post(event);
    }

    /**
     * 注册观察者
     *
     * @param subscriber 观察者
     * @param <T>        观察者类型定义
     */
    public <T> void regist(@NonNull T subscriber) {
        evnetBus.register(subscriber);
    }

    /**
     * 注册观察者
     *
     * @param subscriber 观察者
     * @param <T>        观察者类型定义
     */
    public <T> void unRegist(@NonNull T subscriber) {
        evnetBus.unregister(subscriber);
    }
}
