package com.rabbit.blade.domain.operator;

import com.rabbit.blade.domain.event.DomainEventProvider;
import com.rabbit.blade.domain.event.MessageEvent;

import rx.Observable;
import rx.Producer;
import rx.Subscriber;
import rx.exceptions.Exceptions;
import rx.exceptions.OnErrorThrowable;
import rx.functions.Func1;
import rx.plugins.RxJavaHooks;

/**
 * <b>Description : 自定义的消息发布操作符</b>
 * <p>Created by <a href="mailto:fanjiandong@outlook.com">fanjiandong</a> on 2016/12/27 21:37.</p>
 */

public class OperatorMessage<T, P> implements Observable.Operator<T, T> {

    private final Func1<T, MessageEvent<P>> messageEventFunc1;

    public OperatorMessage(Func1<T, MessageEvent<P>> messageEventFunc1) {
        this.messageEventFunc1 = messageEventFunc1;
    }

    @Override
    public Subscriber<? super T> call(Subscriber<? super T> subscriber) {
        ProgressSubscriber<T, P> parent = new ProgressSubscriber<>(subscriber, messageEventFunc1);
        subscriber.add(parent);
        return parent;
    }

    static final class ProgressSubscriber<T, P> extends Subscriber<T> {

        final Subscriber<? super T> actual;

        private final Func1<T, MessageEvent<P>> messageEventFunc1;

        boolean done;

        protected ProgressSubscriber(Subscriber<? super T> actual, Func1<T, MessageEvent<P>> messageEventFunc1) {
            this.actual = actual;
            this.messageEventFunc1 = messageEventFunc1;
        }

        @Override
        public void onNext(T t) {
            MessageEvent<P> result;
            try {
                result = messageEventFunc1.call(t);
                DomainEventProvider.instance().publish(result);
            } catch (Throwable ex) {
                Exceptions.throwIfFatal(ex);
                unsubscribe();
                onError(OnErrorThrowable.addValueAsLastCause(ex, t));
                return;
            }

            actual.onNext(t);
        }

        @Override
        public void onError(Throwable e) {
            if (done) {
                RxJavaHooks.onError(e);
                return;
            }
            done = true;

            actual.onError(e);
        }


        @Override
        public void onCompleted() {
            if (done) {
                return;
            }
            actual.onCompleted();
        }

        @Override
        public void setProducer(Producer p) {
            actual.setProducer(p);
        }
    }
}
