/*
 * Decompiled with CFR 0.152.
 */
package com.rabbit.blade.domain.operator;

import com.rabbit.blade.comm.event.DefaultBusProvider;
import com.rabbit.blade.domain.event.MessageEvent;
import rx.Observable;
import rx.Producer;
import rx.Subscriber;
import rx.exceptions.Exceptions;
import rx.exceptions.OnErrorThrowable;
import rx.functions.Func1;
import rx.plugins.RxJavaHooks;

public class OperatorMessage<T, P>
implements Observable.Operator<T, T> {
    private final Func1<T, MessageEvent<P>> messageEventFunc1;

    public OperatorMessage(Func1<T, MessageEvent<P>> messageEventFunc1) {
        this.messageEventFunc1 = messageEventFunc1;
    }

    public Subscriber<? super T> call(Subscriber<? super T> subscriber) {
        ProgressSubscriber<? super T, P> parent = new ProgressSubscriber<T, P>(subscriber, this.messageEventFunc1);
        subscriber.add(parent);
        return parent;
    }

    static final class ProgressSubscriber<T, P>
    extends Subscriber<T> {
        final Subscriber<? super T> actual;
        private final Func1<T, MessageEvent<P>> messageEventFunc1;
        boolean done;

        protected ProgressSubscriber(Subscriber<? super T> actual, Func1<T, MessageEvent<P>> messageEventFunc1) {
            this.actual = actual;
            this.messageEventFunc1 = messageEventFunc1;
        }

        public void onNext(T t) {
            try {
                MessageEvent result = (MessageEvent)this.messageEventFunc1.call(t);
                DefaultBusProvider.instance().post((Object)result);
            }
            catch (Throwable ex) {
                Exceptions.throwIfFatal((Throwable)ex);
                this.unsubscribe();
                this.onError(OnErrorThrowable.addValueAsLastCause((Throwable)ex, t));
                return;
            }
            this.actual.onNext(t);
        }

        public void onError(Throwable e) {
            if (this.done) {
                RxJavaHooks.onError((Throwable)e);
                return;
            }
            this.done = true;
            this.actual.onError(e);
        }

        public void onCompleted() {
            if (this.done) {
                return;
            }
            this.actual.onCompleted();
        }

        public void setProducer(Producer p) {
            this.actual.setProducer(p);
        }
    }
}

