/*
 * Decompiled with CFR 0.152.
 */
package com.rabbit.blade.domain.test;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import junit.framework.Assert;
import rx.functions.Action1;

public class TestAction1<T>
implements Action1<T> {
    private final CountDownLatch latch = new CountDownLatch(1);
    private final List<T> agentMessages = new ArrayList<T>(3);
    private int messageCount;

    public void await(long timeout, int expectedResultCount) {
        try {
            this.messageCount = expectedResultCount;
            this.latch.await(timeout, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    public void await(int expectedResultCount) {
        this.await(3600000L, expectedResultCount);
    }

    public void call(T result) {
        this.agentMessages.add(result);
        if (this.agentMessages.size() >= this.messageCount) {
            this.latch.countDown();
        }
    }

    public void assertValueCount(int expectedResultsCount) {
        Assert.assertEquals((int)this.agentMessages.size(), (int)expectedResultsCount);
    }

    public void assertValue(T expectedResult) {
        int size = this.agentMessages.size();
        Assert.assertEquals((int)size, (int)1);
        T am = this.agentMessages.get(0);
        Assert.assertEquals(am, expectedResult);
    }

    @SafeVarargs
    public final void assertValues(T ... expectedResults) {
        int length = expectedResults.length;
        int size = this.agentMessages.size();
        Assert.assertEquals((int)length, (int)size);
        for (int index = 0; index < expectedResults.length; ++index) {
            T am = expectedResults[index];
            T agentMessage = this.agentMessages.get(index);
            Assert.assertEquals(am, agentMessage);
            Assert.assertEquals(am, agentMessage);
        }
    }
}

