package com.rabbit.blade.domain.event;

/**
 * <b>Description : 可分类的领域事件 </b>
 * <p>Created by <a href="mailto:fjd@xdja.com">fanjiandong</a> on 2017/1/7 16:20.</p>
 */
public class CategoryEvent<T, C> extends MaterialEvent<T> {

    private C category;

    public CategoryEvent() {
        super();
    }

    public CategoryEvent(final C category) {
        super();
        this.category = category;
    }

    public CategoryEvent(final C category, final T materialContent) {
        super(materialContent);
        this.category = category;
    }

    public CategoryEvent(final C category, long eventId, T materialContent) {
        super(eventId, materialContent);
        this.category = category;
    }

    public void setCategory(C category) {
        this.category = category;
    }

    public C getCategory() {
        return category;
    }
}
