package com.rabbit.blade.domain.event;

import java.util.Date;

/**
 * <b>Description : 领域事件基础实现</b>
 * <p>Created by <a href="mailto:fjd@xdja.com">fanjiandong</a> on 2017/1/6 17:23.</p>
 */

public class DispatchableDomainEvent implements DomainEvent {

    private final Date date;

    private final long eventId;

    public DispatchableDomainEvent(final long eventId) {
        this.date = new Date();
        this.eventId = eventId;
    }

    public long getEventId() {
        return this.eventId;
    }

    @Override
    public long occurTime() {
        return this.date.getTime();
    }

    @Override
    public int version() {
        return 0;
    }
}
