package com.rabbit.blade.domain.event;

import java.util.UUID;

/**
 * <b>Description : 扩展的领域事件实现 </b>
 * <p>Created by <a href="mailto:fjd@xdja.com">fanjiandong</a> on 2017/1/7 15:59.</p>
 */

public class MaterialEvent<T> extends DispatchableDomainEvent {

    private T materialContent;

    public MaterialEvent() {
        this(null);
    }

    public MaterialEvent(final T materialContent) {
        this(UUID.randomUUID().hashCode(), materialContent);
    }

    public MaterialEvent(final long eventId, final T materialContent) {
        super(eventId);
        this.materialContent = materialContent;
    }

    public void setMaterialContent(T materialContent) {
        this.materialContent = materialContent;
    }

    public T getMaterialContent() {
        return materialContent;
    }
}
