package com.rabbit.blade.domain.test;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;

import rx.functions.Action1;

import static junit.framework.Assert.assertEquals;

/**
 * <b>Description : 用于单元测试的消息发布操作符消息订阅者</b>
 * <p>Created by <a href="mailto:fjd@xdja.com">fanjiandong</a> on 2017/3/14 9:45.</p>
 *
 * @param <T> the type parameter
 */
public class TestAction1<T> implements Action1<T> {

    private final CountDownLatch latch = new CountDownLatch(1);

    private final List<T> agentMessages = new ArrayList<>(3);

    private int messageCount;


    /**
     * Instantiates a new Test action 1.
     */
    public TestAction1() {}


    /**
     * Await.
     *
     * @param timeout             the timeout
     * @param expectedResultCount the expected result count
     */
    public void await(long timeout, int expectedResultCount) {
        try {
            this.messageCount = expectedResultCount;
            latch.await(timeout, TimeUnit.MILLISECONDS);
        } catch (InterruptedException e) {
            e.printStackTrace();
        }
    }


    /**
     * Await.
     *
     * @param expectedResultCount the expected result count
     */
    public void await(int expectedResultCount) {
        await(1000 * 3600, expectedResultCount);
    }

    @Override
    public void call(T result) {
        agentMessages.add(result);
        if (agentMessages.size() >= messageCount) {
            latch.countDown();
        }
    }

    /**
     * Assert value count.
     *
     * @param expectedResultsCount the expected results count
     */
    public void assertValueCount(int expectedResultsCount) {
        assertEquals(agentMessages.size(), expectedResultsCount);
    }


    /**
     * Assert value.
     *
     * @param expectedResult the expected result
     */
    public void assertValue(T expectedResult) {
        int size = agentMessages.size();
        assertEquals(size, 1);
        T am = agentMessages.get(0);
        assertEquals(am, expectedResult);
    }


    /**
     * Assert values.
     *
     * @param expectedResults the expected results
     */
    @SafeVarargs
    public final void assertValues(T... expectedResults) {
        int length = expectedResults.length;
        int size = this.agentMessages.size();
        assertEquals(length, size);

        for (int index = 0; index < expectedResults.length; index++) {
            T am = expectedResults[index];
            T agentMessage = this.agentMessages.get(index);
            assertEquals(am, agentMessage);
            assertEquals(am, agentMessage);
        }
    }
}
