package com.rabbit.blade.domain.test;

import com.rabbit.blade.domain.event.AgentMessage;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;

import rx.functions.Action1;

import static junit.framework.Assert.assertEquals;

/**
 * <b>Description : 用于单元测试的消息发布操作符消息订阅者</b>
 * <p>Created by <a href="mailto:fjd@xdja.com">fanjiandong</a> on 2017/3/14 9:45.</p>
 */
public class TestMessageAction implements Action1<AgentMessage<?>> {

    private final CountDownLatch latch = new CountDownLatch(1);

    private final List<AgentMessage<?>> agentMessages = new ArrayList<>(3);

    private int messageCount;

    /**
     * Instantiates a new Test message action.
     */
    public TestMessageAction() {}

    /**
     * Await.
     *
     * @param timeout          the timeout
     * @param expectedMsgCount the wait message count
     */
    public void await(long timeout, int expectedMsgCount) {
        try {
            this.messageCount = expectedMsgCount;
            latch.await(timeout, TimeUnit.MILLISECONDS);
        } catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    /**
     * Await.
     *
     * @param expectedMsgCount the expected msg count
     */
    public void await(int expectedMsgCount) {
        await(1000 * 3600, expectedMsgCount);
    }

    @Override
    public void call(AgentMessage<?> agentMessage) {
        agentMessages.add(agentMessage);
        if (agentMessages.size() >= messageCount) {
            latch.countDown();
        }
    }

    /**
     * Assert value count.
     *
     * @param messageCount the message count
     */
    public void assertValueCount(int messageCount) {
        assertEquals(agentMessages.size(), messageCount);
    }

    /**
     * Assert value.
     *
     * @param agentMessage the agent message
     */
    public void assertValueContent(AgentMessage<?> agentMessage) {
        int size = agentMessages.size();
        assertEquals(size, 1);
        AgentMessage<?> am = agentMessages.get(0);
        assertEquals(am.getObject(), agentMessage.getObject());
        assertEquals(am.getWhat(), agentMessage.getWhat());
    }

    /**
     * Assert values.
     *
     * @param agentMessages the agent messages
     */
    public void assertValuesContent(AgentMessage<?>... agentMessages) {
        int length = agentMessages.length;
        int size = this.agentMessages.size();
        assertEquals(length, size);

        for (int index = 0; index < agentMessages.length; index++) {
            AgentMessage<?> am = agentMessages[index];
            AgentMessage<?> agentMessage = this.agentMessages.get(index);
            assertEquals(am.getObject(), agentMessage.getObject());
            assertEquals(am.getWhat(), agentMessage.getWhat());
        }
    }
}
