package com.rabbit.blade.presenter;

import android.app.Application;
import android.content.ComponentCallbacks;
import android.content.res.Configuration;

/**
 * <b>Description : 模拟的Application生命周期实现类定义</b>
 * <p>Created by <a href="mailto:fanjiandong@outlook.com">fanjiandong</a> on 2017/3/20 14:07.</p>
 */

public interface BoundedApplication {
    /**
     * 原则上该方法会在系统Application执行onCreate生命周期时执行
     * <P>注意：由于该方法中的具体业务逻辑会有一些前置依赖，如：在此方法中调用安全卡操作，那么前置条件为该安全卡已初始化。</P>
     * <p>这些前置条件应该由各子模块与主模块进行协商沟通，主模块应该保证在各前置条件满足后再调用该方法。</p>
     *
     * @param application 有效的Application
     */
    void onCreate(Application application);

    /**
     * {@link Application#onTerminate()}
     */
    void onTerminate();

    /**
     * {@link Application#onConfigurationChanged(Configuration newConfig)}
     */
    void onConfigurationChanged(Configuration newConfig);

    /**
     * {@link Application#onLowMemory()}
     */
    void onLowMemory();

    /**
     * {@link Application#onTrimMemory(int level)}
     */
    void onTrimMemory(int level);

    /**
     * {@link Application#registerComponentCallbacks(ComponentCallbacks callback)}
     */
    void registerComponentCallbacks(ComponentCallbacks callback);

    /**
     * {@link Application#unregisterComponentCallbacks(ComponentCallbacks callback)}
     */
    void unregisterComponentCallbacks(ComponentCallbacks callback);

    /**
     * {@link Application#registerActivityLifecycleCallbacks(Application.ActivityLifecycleCallbacks callback)}
     */
    void registerActivityLifecycleCallbacks(Application.ActivityLifecycleCallbacks callback);

    /**
     * {@link Application#unregisterActivityLifecycleCallbacks(Application.ActivityLifecycleCallbacks callback)}
     */
    void unregisterActivityLifecycleCallbacks(Application.ActivityLifecycleCallbacks callback);

    /**
     * {@link Application#registerOnProvideAssistDataListener(Application.OnProvideAssistDataListener callback)}
     */
    void registerOnProvideAssistDataListener(Application.OnProvideAssistDataListener callback);

    /**
     * {@link Application#unregisterOnProvideAssistDataListener(Application.OnProvideAssistDataListener callback)}
     */
    void unregisterOnProvideAssistDataListener(Application.OnProvideAssistDataListener callback);
}
