package com.rabbit.blade.presenter.assist;

import android.support.annotation.NonNull;
import android.support.annotation.StringRes;

/**
 * <b>Description : 消息提示接口</b>
 * <p>Created by <a href="mailto:fanjiandong@outlook.com">fanjiandong</a> on 2017/1/18 14:32.</p>
 */
public interface Cake {
    /**
     * 展示提示信息
     *
     * @param resId 提示信息资源ID
     */
    void showCake(@StringRes int resId);

    /**
     * 展示提示信息
     *
     * @param message 提示信息
     */
    void showCake(@NonNull String message);

    /**
     * 展示正确“积极”的提示信息
     *
     * @param resId 提示信息资源ID
     */
    void showSweetCake(@StringRes int resId);

    /**
     * 展示正确“积极”的提示信息
     *
     * @param message 提示信息
     */
    void showSweetCake(@NonNull String message);

    /**
     * 展示错误“消极”的提示信息
     *
     * @param resId 提示信息资源ID
     */
    void showBitterCake(@StringRes int resId);

    /**
     * 展示错误“消极”的提示信息
     *
     * @param message 提示信息
     */
    void showBitterCake(@NonNull String message);

    /**
     * 展示警告“变质”的提示信息
     *
     * @param resId 提示信息资源ID
     */
    void showAlterantCake(@StringRes int resId);

    /**
     * 展示警告“变质”的提示信息
     *
     * @param message 提示信息
     */
    void showAlterantCake(@NonNull String message);
}
