package com.rabbit.blade.presenter.assist;

import android.app.Activity;
import android.app.ProgressDialog;
import android.content.DialogInterface;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.StringRes;


/**
 * <b>Description : 进度加载接口默认实现类</b>
 * <p>Created by <a href="mailto:fanjiandong@outlook.com">fanjiandong</a> on 2017/1/18 17:02.</p>
 */

public class DialogLoader implements Loader {

    private final Activity activity;

    private ProgressDialog loadingDialog;

    public DialogLoader(@NonNull Activity activity) {
        this.activity = activity;
        this.loadingDialog = new ProgressDialog(this.activity);
        this.loadingDialog.setProgressStyle(ProgressDialog.STYLE_SPINNER);
        this.loadingDialog.setCancelable(true);
        this.loadingDialog.setCanceledOnTouchOutside(false);
    }

    @Override
    public void loadingMessage(@Nullable String msg,
                               boolean isCancelable,
                               @Nullable final DialogInterface.OnCancelListener cancelListener) {
        this.loadingDialog.setMessage(msg);
        this.loadingDialog.setCancelable(isCancelable);
        if (isCancelable) {
            this.loadingDialog.setOnCancelListener(cancelListener);
        }
        if (!this.loadingDialog.isShowing()) {
            this.loadingDialog.show();
        }
    }

    @Override
    public void loadingMessage(@StringRes int resId,
                               boolean isCancelable,
                               @Nullable final DialogInterface.OnCancelListener cancelListener) {
        String msg = this.activity.getString(resId);
        loadingMessage(msg, isCancelable, cancelListener);
    }

    @Override
    public void cancel() {
        if (this.loadingDialog != null && this.loadingDialog.isShowing()) {
            this.loadingDialog.dismiss();
        }
    }
}
