package com.rabbit.blade.presenter.assist;

import android.support.annotation.Nullable;

import com.rabbit.blade.comm.exeption.OkException;


/**
 * <b>Description : 异常处理接口</b>
 * <p>Created by <a href="mailto:fanjiandong@outlook.com">fanjiandong</a> on 2017/1/18 14:32.</p>
 */
public interface FlyHunter {

    /**
     * 处理OkException异常
     *
     * @param okCode  错误码
     * @param userMsg 用户信息
     * @param ex      错误完整信息
     * @param mark    业务标识
     * @return 是否阻止进行默认处理
     */
    boolean handleOkException(@Nullable String okCode, @Nullable String userMsg,
                              @Nullable OkException ex, @Nullable String mark);

    /**
     * OkException的默认处理方法
     *
     * @param code    错误码
     * @param userMsg 用户信息
     * @param ex      错误完整信息
     * @param mark    业务标识
     */
    void defaultOkException(@Nullable String code, @Nullable String userMsg,
                            @Nullable OkException ex, @Nullable String mark);

    /**
     * 处理Throwable错误
     *
     * @param throwable Throwable对象
     * @param mark      业务标识
     * @return 是否阻止进行默认处理
     */
    boolean handlerThrowable(@Nullable Throwable throwable, @Nullable String mark);

    /**
     * 处理Throwable错误
     *
     * @param throwable Throwable对象
     * @param mark      业务标识
     */
    void defaultThrowable(@Nullable Throwable throwable, @Nullable String mark);
}
