package com.rabbit.blade.presenter.assist;

import android.support.annotation.Nullable;

import com.blankj.utilcode.utils.NetworkUtils;

import javax.net.ssl.SSLHandshakeException;

/**
 * <b>Description : 辨别全局性的，非业务性异常的处理类</b>
 * <p>Created by <a href="mailto:fanjiandong@outlook.com">fanjiandong</a> on 2017/2/3 11:53.</p>
 */

public class FlyRepo {

    public static void recognizeFly(@Nullable Throwable throwable) throws RuntimeException {
        if (throwable == null) return;

        if (throwable instanceof java.net.SocketTimeoutException
                || throwable instanceof java.net.ConnectException) {
            String errorMsg = "网络请求已超时，请检查网络后重试";
            if (!NetworkUtils.isConnected()) {
                errorMsg = "网络不可用，请检查网络设置";
            }
            throw new RuntimeException(errorMsg);
        } else if (throwable instanceof SSLHandshakeException
                && throwable.getMessage().contains("ExtCertPathValidatorException")) {
            throw new RuntimeException("当前时间与北京时间不一致，当前操作存在风险");
        }
    }
}
