package com.rabbit.blade.presenter.assist;

import android.content.DialogInterface;
import android.support.annotation.Nullable;
import android.support.annotation.StringRes;

/**
 * <b>Description : 进度加载接口</b>
 * <p>Created by <a href="mailto:fanjiandong@outlook.com">fanjiandong</a> on 2016/10/17 17:22.</p>
 */

public interface Loader {
    /**
     * 展示进度提示
     *
     * @param msg            提示信息
     * @param isCancelable   是否可以取消
     * @param cancelListener 取消监听
     */
    void loadingMessage(@Nullable String msg,
                        boolean isCancelable,
                        @Nullable DialogInterface.OnCancelListener cancelListener);

    /**
     * 展示进度提示
     *
     * @param resId          提示信息资源ID
     * @param isCancelable   是否可以取消
     * @param cancelListener 取消监听
     */
    void loadingMessage(@StringRes int resId,
                        boolean isCancelable,
                        @Nullable DialogInterface.OnCancelListener cancelListener);

    /**
     * 取消进度提示
     */
    void cancel();
}
