package com.rabbit.blade.presenter.assist;

import android.support.annotation.Nullable;

import com.rabbit.blade.comm.BuildConfig;
import com.rabbit.blade.comm.util.LogUtil;

import rx.Subscriber;

/**
 * <b>Description : 可以处理OkException的观察者</b>
 * <p>Created by <a href="mailto:fanjiandong@outlook.com">fanjiandong</a> on 2017/3/20 13:50.</p>
 */

public class OkSubscriber<T> extends Subscriber<T> {

    /**
     * 异常处理对象
     */
    private final PlanFly planFly;

    /**
     * 为当前异常附加一个业务标识
     */
    private String mark = "default_mark";

    public PlanFly getPlanFly() {
        return planFly;
    }


    public String getMark() {
        return mark;
    }


    public OkSubscriber(@Nullable PlanFly planFly, @Nullable String mark) {
        this.planFly = planFly;
        this.mark = mark;
    }

    public OkSubscriber(@Nullable PlanFly planFly) {
        this(planFly, null);
    }

    @Override
    public void onNext(T t) {
        LogUtil.getUtils().i("=================onNext=================");
    }

    @Override
    public void onCompleted() {
        LogUtil.getUtils().i("=================onCompleted=================");
    }

    @Override
    public void onError(Throwable e) {
        LogUtil.getUtils().w("=================onError=================");
        if (BuildConfig.DEBUG) {
            e.printStackTrace();
        }
        if (this.planFly != null) {
            this.planFly.plan(e, this.mark);
        }
    }
}
