package com.rabbit.blade.presenter.assist;

import android.support.annotation.Nullable;
import android.text.TextUtils;

import com.rabbit.blade.comm.exeption.OkException;
import com.rabbit.blade.comm.exeption.OkMatcher;
import com.rabbit.blade.comm.util.LogUtil;

import javax.inject.Inject;

/**
 * <b>Description : 该类用于识别并处理异常</b>
 * <p>Created by <a href="mailto:fanjiandong@outlook.com">fanjiandong</a> on 2017/1/19 15:16.</p>
 */

public class PlanFly {
    /**
     * 异常处理对象
     */
    private final FlyHunter hunter;
    /**
     * 异常匹配对象
     */
    private final OkMatcher matcher;

    public FlyHunter getHunter() {
        return hunter;
    }

    public OkMatcher getMatcher() {
        return matcher;
    }

    @Inject
    public PlanFly(@Nullable FlyHunter hunter, @Nullable OkMatcher matcher) {
        this.hunter = hunter;
        this.matcher = matcher;
    }

    /**
     * 处理异常
     *
     * @param e    异常对象
     * @param mark 业务标识
     */
    public void plan(Throwable e, @Nullable String mark) {

        if (e == null) return;

        LogUtil.getUtils().w(e.getMessage());

        if (e instanceof OkException) {
            huntOkFly((OkException) e, mark);
        } else {
            huntFly(e, mark);
        }
    }

    /**
     * 处理未识别的异常
     *
     * @param e    异常对象
     * @param mark 业务标识
     */
    private void huntFly(Throwable e, @Nullable String mark) {
        LogUtil.getUtils().w("捕获到未定义的异常 : " + e.getMessage());
        if (this.hunter != null) {
            boolean result = this.hunter.handlerThrowable(e, mark);
            if (!result) {
                this.hunter.defaultThrowable(e, mark);
            }
        }
    }

    /**
     * 处理能识别的异常
     *
     * @param okException 异常对象
     * @param mark        业务标识
     */
    private void huntOkFly(OkException okException, @Nullable String mark) {
        LogUtil.getUtils().w("捕获到OkException : " + okException.toString());
        String matchResult = "";
        if (this.matcher != null) {
            matchResult = matcher.match(okException);

            if (TextUtils.isEmpty(matchResult)) {
                matchResult = okException.getMessage();
            }

            if (TextUtils.isEmpty(matchResult)) {
                LogUtil.getUtils().d("匹配到的用户信息为空");
            } else {
                LogUtil.getUtils().d("匹配到的用户信息为 ： " + matchResult);
            }
        }

        if (this.hunter != null) {
            boolean result = this.hunter.handleOkException(okException.getOkCode(), matchResult, okException, mark);
            if (!result) {
                this.hunter.defaultOkException(okException.getOkCode(), matchResult, okException, mark);
            }
        }
    }
}
