package com.rabbit.blade.presenter.assist;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.StringRes;

import com.rabbit.blade.presenter.widget.XToast;


/**
 * <b>Description : Toast提示实现类</b>
 * <p>Created by <a href="mailto:fanjiandong@outlook.com">fanjiandong</a> on 2017/1/18 16:57.</p>
 */

public class ToastCake implements Cake {

    private final Context context;

    public ToastCake(@NonNull Context context) {
        this.context = context.getApplicationContext();
    }

    @Override
    public void showCake(@StringRes int resId) {
        XToast.show(this.context, resId);
    }

    @Override
    public void showCake(@NonNull String message) {
        XToast.show(this.context, message);
    }

    @Override
    public void showSweetCake(@StringRes int resId) {
        XToast.showOK(this.context, this.context.getString(resId));
    }

    @Override
    public void showSweetCake(@NonNull String message) {
        XToast.showOK(this.context, message);
    }

    @Override
    public void showBitterCake(@StringRes int resId) {
        XToast.showBottomWrongToast(this.context, this.context.getString(resId));
    }

    @Override
    public void showBitterCake(@NonNull String message) {
        XToast.showBottomWrongToast(this.context, message);
    }

    @Override
    public void showAlterantCake(@StringRes int resId) {
        XToast.showBottomWrongToast(this.context, this.context.getString(resId));
    }

    @Override
    public void showAlterantCake(@NonNull String message) {
        XToast.showBottomWrongToast(this.context, message);
    }
}
