package com.rabbit.blade.presenter.di.components;

import com.rabbit.blade.presenter.di.modules.ApplicationModule;
import com.rabbit.blade.presenter.di.modules.EventModule;
import com.rabbit.blade.presenter.di.modules.ExecutorModule;
import com.rabbit.blade.presenter.di.modules.NetworkModule;
import com.rabbit.blade.presenter.di.modules.UtilModule;

import javax.inject.Singleton;

import dagger.Component;

/**
 * <b>Description : Application注入控制器</b>
 * <p>Created by <a href="mailto:fanjiandong@outlook.com">fanjiandong</a> on 2017/3/20 13:53.</p>
 */
@Singleton
@Component(
        modules = {
                ApplicationModule.class,
                EventModule.class,
                ExecutorModule.class,
                NetworkModule.class,
                UtilModule.class
        }
)
public interface ApplicationComponent extends Providers.ApplicationComponentProvider{
    ActivityComponent.Builder activityComponentBuilder();
}
