package com.rabbit.blade.presenter.di.modules;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;

import com.rabbit.blade.comm.annotation.DiConfig;
import com.rabbit.blade.comm.annotation.qua.AroundQua;
import com.rabbit.blade.comm.annotation.scop.PerActivity;
import com.rabbit.blade.presenter.assist.AssistProvider;
import com.rabbit.blade.presenter.assist.Cake;
import com.rabbit.blade.presenter.assist.FlyHunter;
import com.rabbit.blade.presenter.assist.Loader;
import com.rabbit.blade.presenter.di.components.FragmentComponent;
import com.rabbit.blade.presenter.main.SmartActivity;

import dagger.Module;
import dagger.Provides;

/**
 * <b>Description : Activity注入提供者</b>
 * <p>Created by <a href="mailto:fanjiandong@outlook.com">fanjiandong</a> on 2017/3/20 13:54.</p>
 */

@Module(subcomponents = FragmentComponent.class)
public class ActivityModule {

    private final SmartActivity smartActivity;

    public ActivityModule(@NonNull SmartActivity smartActivity) {
        this.smartActivity = smartActivity;
    }

    @Provides
    @PerActivity
    @AroundQua(DiConfig.QUA_ACTIVITY)
    Activity provideActivity() {
        return this.smartActivity;
    }

    @Provides
    @PerActivity
    @AroundQua(DiConfig.QUA_ACTIVITY)
    Context provideContext() {
        return this.smartActivity;
    }

    @PerActivity
    @Provides
    Intent provideIntent() {
        return this.smartActivity.getIntent();
    }

    @Provides
    @PerActivity
    @AroundQua(DiConfig.QUA_ACTIVITY)
    @Nullable
    Bundle provideBundle(Intent intent) {
        return intent.getExtras();
    }

    @Provides
    @PerActivity
    @AroundQua(DiConfig.QUA_ACTIVITY)
    AssistProvider provideAssist() {
        return this.smartActivity;
    }

    @Provides
    @PerActivity
    @AroundQua(DiConfig.QUA_ACTIVITY)
    Loader provideLoader(@AroundQua(DiConfig.QUA_ACTIVITY)
                                 AssistProvider assistProvider) {
        return assistProvider.provideLoader();
    }

    @Provides
    @PerActivity
    @AroundQua(DiConfig.QUA_ACTIVITY)
    Cake provideCake(@AroundQua(DiConfig.QUA_ACTIVITY)
                             AssistProvider assistProvider) {
        return assistProvider.provideCake();
    }

    @Provides
    @PerActivity
    @AroundQua(DiConfig.QUA_ACTIVITY)
    FlyHunter provideFlyHunter(@AroundQua(DiConfig.QUA_ACTIVITY)
                                       AssistProvider assistProvider) {
        return assistProvider.provideFlyHunter();
    }

    public interface Provider {
        @AroundQua(DiConfig.QUA_ACTIVITY)
        Activity activity();

        @AroundQua(DiConfig.QUA_ACTIVITY)
        Context activityContext();

        Intent intent();

        @Nullable
        @AroundQua(DiConfig.QUA_ACTIVITY)
        Bundle activityBundle();

        @AroundQua(DiConfig.QUA_ACTIVITY)
        AssistProvider activityAssist();

        @AroundQua(DiConfig.QUA_ACTIVITY)
        Loader activityLoader();

        @AroundQua(DiConfig.QUA_ACTIVITY)
        Cake activityCake();

        @Nullable
        @AroundQua(DiConfig.QUA_ACTIVITY)
        FlyHunter activityFlyHunter();
    }
}
