package com.rabbit.blade.presenter.di.modules;

import android.app.ActivityManager;
import android.app.AlarmManager;
import android.app.NotificationManager;
import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.view.LayoutInflater;

import com.rabbit.blade.comm.annotation.DiConfig;
import com.rabbit.blade.comm.annotation.qua.AroundQua;
import com.rabbit.blade.presenter.AndroidApplication;
import com.rabbit.blade.presenter.assist.AssistProvider;
import com.rabbit.blade.presenter.assist.Cake;
import com.rabbit.blade.presenter.assist.FlyHunter;
import com.rabbit.blade.presenter.assist.Loader;
import com.rabbit.blade.presenter.di.components.ActivityComponent;

import javax.inject.Singleton;

import dagger.Module;
import dagger.Provides;

/**
 * <b>Description : Application依赖提供者</b>
 * <p>Created by <a href="mailto:fanjiandong@outlook.com">fanjiandong</a> on 2017/3/20 13:54.</p>
 */

@Module(subcomponents = {ActivityComponent.class})
public class ApplicationModule {

    private final AndroidApplication application;

    public ApplicationModule(@NonNull AndroidApplication application) {
        this.application = application;
    }

    @Provides
    @Singleton
    @AroundQua(DiConfig.QUA_APPLICATION)
    Context provideApplicationContext() {
        return this.application;
    }

    @Provides
    @Singleton
    LayoutInflater provideLayoutInflater() {
        return LayoutInflater.from(this.application);
    }

    @Singleton
    @Provides
    ActivityManager provideActivityManager() {
        return ((ActivityManager) this.application.getSystemService(Context.ACTIVITY_SERVICE));
    }

    @Singleton
    @Provides
    AlarmManager provideAlarmManager() {
        return ((AlarmManager) this.application.getSystemService(Context.ALARM_SERVICE));
    }

    @Singleton
    @Provides
    NotificationManager provideNotificationManager() {
        return ((NotificationManager) this.application.getSystemService(Context.NOTIFICATION_SERVICE));
    }

    @Singleton
    @Provides
    @AroundQua(DiConfig.QUA_APPLICATION)
    AssistProvider provideAssist(){
        return this.application;
    }

    @Singleton
    @Provides
    @AroundQua(DiConfig.QUA_APPLICATION)
    Cake provideCake(@AroundQua(DiConfig.QUA_APPLICATION) AssistProvider assistProvider) {
        return assistProvider.provideCake();
    }

    @Provides
    @Singleton
    @AroundQua(DiConfig.QUA_APPLICATION)
    @Nullable
    Loader provideLoader(@AroundQua(DiConfig.QUA_APPLICATION) AssistProvider assistProvider) {
        return assistProvider.provideLoader();
    }

    @Singleton
    @Provides
    @AroundQua(DiConfig.QUA_APPLICATION)
    FlyHunter provideFlyHunter(@AroundQua(DiConfig.QUA_APPLICATION) AssistProvider assistProvider) {
        return assistProvider.provideFlyHunter();
    }

    public interface Provider{
        @AroundQua(DiConfig.QUA_APPLICATION)
        Context applicationContext();

        LayoutInflater layoutInflater();

        ActivityManager activityManager();

        AlarmManager alarmManager();

        NotificationManager notificationmanager();

        @AroundQua(DiConfig.QUA_APPLICATION)
        AssistProvider applicationAssist();

        @AroundQua(DiConfig.QUA_APPLICATION)
        Cake applicationCake();

        @AroundQua(DiConfig.QUA_APPLICATION)
        @Nullable
        Loader applicationLoader();

        @AroundQua(DiConfig.QUA_APPLICATION)
        FlyHunter applicationFlyHunter();
    }
}
