package com.rabbit.blade.presenter.di.modules;


import com.rabbit.blade.data.excutor.ThreadExecutorImpl;
import com.rabbit.blade.data.excutor.UIThreadImpl;
import com.rabbit.blade.domain.excutor.PostExecutionThread;
import com.rabbit.blade.domain.excutor.ThreadExecutor;

import javax.inject.Singleton;

import dagger.Module;
import dagger.Provides;

/**
 * <b>Description : 调度器相关注入提供者</b>
 * <p>Created by <a href="mailto:fanjiandong@outlook.com">fanjiandong</a> on 2017/3/20 13:55.</p>
 */

@Module
public class ExecutorModule {

    @Provides
    @Singleton
    ThreadExecutor provideThreadExecutor(ThreadExecutorImpl impl) {
        return impl;
    }

    @Singleton
    @Provides
    PostExecutionThread providePostExecutionThread(UIThreadImpl impl) {
        return impl;
    }

    public interface Provider{
        ThreadExecutor threadExecutor();

        PostExecutionThread postExecutionThread();
    }
}
