package com.rabbit.blade.presenter.di.modules;

import android.app.Activity;
import android.content.Context;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.app.Fragment;

import com.rabbit.blade.comm.annotation.DiConfig;
import com.rabbit.blade.comm.annotation.qua.AroundQua;
import com.rabbit.blade.comm.annotation.scop.PerFragment;
import com.rabbit.blade.presenter.assist.AssistProvider;
import com.rabbit.blade.presenter.assist.Cake;
import com.rabbit.blade.presenter.assist.FlyHunter;
import com.rabbit.blade.presenter.assist.Loader;
import com.rabbit.blade.presenter.main.SmartFragment;

import dagger.Module;
import dagger.Provides;

/**
 * <b>Description : Fragment注入提供者</b>
 * <p>Created by <a href="mailto:fanjiandong@outlook.com">fanjiandong</a> on 2017/3/20 13:55.</p>
 */

@Module
public class FragmentModule {

    private final SmartFragment smartFragment;

    public FragmentModule(@NonNull SmartFragment smartFragment) {
        this.smartFragment = smartFragment;
    }

    @PerFragment
    @Provides
    Fragment provideFragment() {
        return this.smartFragment;
    }

    @PerFragment
    @Provides
    @AroundQua(DiConfig.QUA_FRAGMENT)
    Bundle provideBundle() {
        return this.smartFragment.getArguments();
    }

    @PerFragment
    @Provides
    @AroundQua(DiConfig.QUA_FRAGMENT)
    Context provideContext() {
        return this.smartFragment.getContext();
    }

    @PerFragment
    @Provides
    @AroundQua(DiConfig.QUA_FRAGMENT)
    Activity provideActivity() {
        return this.smartFragment.getActivity();
    }

    @PerFragment
    @Provides
    @AroundQua(DiConfig.QUA_FRAGMENT)
    AssistProvider provideAssist() {
        return this.smartFragment;
    }

    @Provides
    @PerFragment
    @AroundQua(DiConfig.QUA_FRAGMENT)
    Loader provideLoader(@AroundQua(DiConfig.QUA_FRAGMENT)
                                 AssistProvider assistProvider) {
        return assistProvider.provideLoader();
    }

    @PerFragment
    @Provides
    @AroundQua(DiConfig.QUA_FRAGMENT)
    Cake provideCake(@AroundQua(DiConfig.QUA_FRAGMENT)
                             AssistProvider assistProvider) {
        return assistProvider.provideCake();
    }

    @PerFragment
    @Provides
    @AroundQua(DiConfig.QUA_FRAGMENT)
    FlyHunter provideFlyHunter(@AroundQua(DiConfig.QUA_FRAGMENT)
                                       AssistProvider assistProvider) {
        return assistProvider.provideFlyHunter();
    }

    public interface Provider{
        Fragment fragment();

        @AroundQua(DiConfig.QUA_FRAGMENT)
        Activity activity4Fragment();

        @AroundQua(DiConfig.QUA_FRAGMENT)
        Context fragmentContext();

        @AroundQua(DiConfig.QUA_FRAGMENT)
        Bundle fragmentBundle();

        @AroundQua(DiConfig.QUA_FRAGMENT)
        AssistProvider fragmentAssist();

        @AroundQua(DiConfig.QUA_FRAGMENT)
        Loader fragmentLoader();

        @AroundQua(DiConfig.QUA_FRAGMENT)
        Cake fragmentCake();

        @Nullable
        @AroundQua(DiConfig.QUA_FRAGMENT)
        FlyHunter fragmentFlyHunter();
    }

}
