package com.rabbit.blade.presenter.di.modules;

import android.content.Context;
import android.support.annotation.NonNull;

import com.rabbit.blade.comm.annotation.DiConfig;
import com.rabbit.blade.comm.annotation.qua.AroundQua;
import com.rabbit.blade.comm.annotation.qua.ConnSecurityQua;
import com.rabbit.blade.data.cache.ConfigCache;
import com.rabbit.blade.data.net.OkHttpsBuilder;
import com.rabbit.blade.data.net.ServiceGenerator;

import javax.inject.Singleton;

import dagger.Module;
import dagger.Provides;
import okhttp3.OkHttpClient;
import okhttp3.logging.HttpLoggingInterceptor;

/**
 * <b>Description : 网络相关注入提供者</b>
 * <p>Created by <a href="mailto:fanjiandong@outlook.com">fanjiandong</a> on 2017/3/20 13:55.</p>
 */

@Module
public class NetworkModule {

    private boolean isLog = true;

    public NetworkModule() {

    }

    public NetworkModule(boolean isLog) {
        this.isLog = isLog;
    }

    @Singleton
    @Provides
    @ConnSecurityQua(DiConfig.CONN_HTTP)
    OkHttpClient.Builder provideOkHttpClientBuilder() {
        OkHttpClient.Builder builder = new OkHttpClient.Builder();
        if (this.isLog) {
            builder.addInterceptor(getHttpLoggingInterceptor());
        }
        return builder;
    }

    @Singleton
    @Provides
    @ConnSecurityQua(DiConfig.CONN_HTTPS)
    OkHttpClient.Builder provideOkHttpsClientBuilder(
            @AroundQua(DiConfig.QUA_APPLICATION) Context context,
            ConfigCache configCache) {
        OkHttpClient.Builder builder = new OkHttpsBuilder(context, configCache).build();
        if (this.isLog) {
            builder.addInterceptor(getHttpLoggingInterceptor());
        }
        return builder;

    }

    @Singleton
    @Provides
    @ConnSecurityQua(DiConfig.CONN_HTTP)
    ServiceGenerator provideHttpServiceGenerator(@ConnSecurityQua(DiConfig.CONN_HTTP)
                                                         OkHttpClient.Builder builder,
                                                 ConfigCache configCache) {
        return new ServiceGenerator(builder, configCache.getConfig("baseUrl"));
    }

    @Singleton
    @Provides
    @ConnSecurityQua(DiConfig.CONN_HTTPS)
    ServiceGenerator provideHttpsServiceGenerator(@ConnSecurityQua(DiConfig.CONN_HTTPS)
                                                          OkHttpClient.Builder builder,
                                                  ConfigCache configCache) {
        return new ServiceGenerator(builder, configCache.getConfig("baseUrl"));
    }

    @NonNull
    public static HttpLoggingInterceptor getHttpLoggingInterceptor() {
        HttpLoggingInterceptor loggingInterceptor = new HttpLoggingInterceptor();
        loggingInterceptor.setLevel(HttpLoggingInterceptor.Level.BODY);
        return loggingInterceptor;
    }

    public interface Provider{

        @ConnSecurityQua(DiConfig.CONN_HTTP)
        OkHttpClient.Builder okHttpClient();

        @ConnSecurityQua(DiConfig.CONN_HTTPS)
        OkHttpClient.Builder okHttpsClient();

        @ConnSecurityQua(DiConfig.CONN_HTTP)
        ServiceGenerator httpService();

        @ConnSecurityQua(DiConfig.CONN_HTTPS)
        ServiceGenerator httpsService();
    }
}
