package com.rabbit.blade.presenter.di.modules;

import android.content.Context;

import com.google.gson.Gson;
import com.rabbit.blade.comm.annotation.DiConfig;
import com.rabbit.blade.comm.annotation.qua.AroundQua;
import com.rabbit.blade.data.cache.ConfigCache;
import com.rabbit.blade.data.cache.ConfigCacheImpl;
import com.rabbit.blade.data.persistent.PreferencesEditor;
import com.rabbit.blade.data.remedy.RemedyCache;
import com.rabbit.blade.data.remedy.RemedyCacheImpl;

import javax.inject.Singleton;

import dagger.Module;
import dagger.Provides;

/**
 * <b>Description : 工具相关注入提供者</b>
 * <p>Created by <a href="mailto:fanjiandong@outlook.com">fanjiandong</a> on 2017/3/20 13:57.</p>
 */

@Module
public class UtilModule {

    @Singleton
    @Provides
    Gson provideGson() {
        return new Gson();
    }

    @Singleton
    @Provides
    ConfigCache provideDefaultConfigCache(ConfigCacheImpl imp) {
        return imp;
    }

    @Singleton
    @Provides
    RemedyCache provideRemedyCache(
            @AroundQua(DiConfig.QUA_APPLICATION) Context context, Gson gson) {
        PreferencesEditor util = new PreferencesEditor(context, "remedies");
        return new RemedyCacheImpl(util, gson);
    }

    @Singleton
    @Provides
    PreferencesEditor providePreferencesEditor(
            @AroundQua(DiConfig.QUA_APPLICATION) Context aContext) {
        return new PreferencesEditor(aContext);
    }

    public interface Provider{
        Gson gson();

        ConfigCache defaultConfigCache();

        RemedyCache remedyCache();

        PreferencesEditor defaultPreferencesEditor();
    }
}
