package com.rabbit.blade.presenter.gui.mvp.annotation;


import com.rabbit.blade.presenter.gui.mvp.view.AdapterView;
import com.rabbit.blade.presenter.gui.mvp.view.FragmentView;
import com.rabbit.blade.presenter.gui.mvp.view.Vu;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * <b>Description : 用于描述MVP绑定关系的注解</b>
 * <p>Created by <a href="mailto:fanjiandong@outlook.com">fanjiandong</a> on 2017/2/18 17:31.</p>
 */
@Documented
@Target(ElementType.TYPE)
@Retention(RetentionPolicy.RUNTIME)
public @interface MVP {

    @Documented
    @Target(ElementType.TYPE)
    @Retention(RetentionPolicy.RUNTIME)
    @interface ACTIVITY {
        boolean presentable() default true;

        Class<? extends Vu.ActivityVu>[] views() default {};
    }

    @Documented
    @Target(ElementType.TYPE)
    @Retention(RetentionPolicy.RUNTIME)
    @interface FRAGMENT {
        boolean presentable() default true;

        Class<? extends Vu.FragmentVu> view() default FragmentView.class;
    }

    @Documented
    @Target(ElementType.TYPE)
    @Retention(RetentionPolicy.RUNTIME)
    @interface ADAPTER {
        boolean presentable() default true;

        Class<? extends Vu.AdapterVu> view() default AdapterView.class;
    }
}
