package com.rabbit.blade.presenter.gui.mvp.cement;

import android.os.Bundle;
import android.support.annotation.Nullable;
import android.support.v7.app.AppCompatActivity;

import com.rabbit.blade.comm.util.LogUtil;
import com.rabbit.blade.presenter.gui.mvp.annotation.MVP;
import com.rabbit.blade.presenter.gui.mvp.presenter.Presenter;
import com.rabbit.blade.presenter.gui.mvp.view.ActivityView;
import com.rabbit.blade.presenter.gui.mvp.view.Vu;


/**
 * <b>Description : 仅仅实现了MVP绑定关系的Activity基类</b>
 * <p>Created by <a href="mailto:fanjiandong@outlook.com">fanjiandong</a> on 2015/5/22 15:21.</p>
 */

public class CementActivity extends AppCompatActivity {

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);

        preMvpBinding(savedInstanceState);

        MVP.ACTIVITY mvpBinderAnn
                = getClass().getAnnotation(MVP.ACTIVITY.class);

        Presenter presenter = getPresenter(mvpBinderAnn);

        Vu.ActivityVu[] views = getActivityVus(mvpBinderAnn);

        if (presenter != null) {
            if (views != null) {
                for (Vu.ActivityVu view : views) {
                    presenter.bindVu(view);
                }
            }
        }

        if (views != null) {
            for (Vu.ActivityVu view : views) {
                if (view != null) {
                    view.bindPresenter(presenter);
                    //设置和View关联的Activity
                    view.bindActivity(this);
                    view.initView(savedInstanceState);
                }
            }
        }

        afterMvpBinding(savedInstanceState);
    }

    private Vu.ActivityVu[] getActivityVus(MVP.ACTIVITY mvpBinderAnn) {
        Vu.ActivityVu views[] = null;
        try {
            if (mvpBinderAnn != null) {
                Class<? extends Vu.ActivityVu>[] vClses = mvpBinderAnn.views();
                if (vClses.length > 0) {
                    views = new Vu.ActivityVu[vClses.length];
                    for (int i = 0; i < vClses.length; i++) {
                        Class<? extends Vu.ActivityVu> vCls = vClses[i];
                        if (vCls != null && !vCls.getName().equals(ActivityView.class.getName())) {
                            views[i] = vCls.newInstance();
                        }
                    }
                }
            }
        } catch (Exception e) {
            LogUtil.getUtils().w(e.getMessage());
        } finally {
            if (views == null) {
                views = provideVus();
            }
        }
        return views;
    }

    private Presenter getPresenter(MVP.ACTIVITY mvpBinderAnn) {
        Presenter presenter = null;
        if (mvpBinderAnn != null) {
            if (mvpBinderAnn.presentable() && this instanceof Presenter) {
                presenter = ((Presenter) this);
            }
        }
        if (presenter == null) {
            presenter = providePresenter();
        }
        return presenter;
    }

    public void preMvpBinding(Bundle savedInstanceState) {}

    public void afterMvpBinding(Bundle savedInstanceState) {}

    public Vu.ActivityVu[] provideVus() {
        Vu.ActivityVu activityVu = provideVu();
        return new Vu.ActivityVu[]{activityVu};
    }

    @Nullable
    public Vu.ActivityVu provideVu() {return null;}

    @Nullable
    public Presenter providePresenter() {return null;}
}
