package com.rabbit.blade.presenter.gui.mvp.cement;

import android.content.Context;
import android.support.annotation.Nullable;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AbsListView;
import android.widget.BaseAdapter;

import com.rabbit.blade.comm.util.LogUtil;
import com.rabbit.blade.presenter.gui.mvp.annotation.MVP;
import com.rabbit.blade.presenter.gui.mvp.presenter.Presenter;
import com.rabbit.blade.presenter.gui.mvp.view.AdapterView;
import com.rabbit.blade.presenter.gui.mvp.view.Vu;

/**
 * <b>Description : 仅仅实现了MVP绑定关系的Adapter基类</b>
 * <p>Created by <a href="mailto:fanjiandong@outlook.com">fanjiandong</a> on 2015/5/22 15:21.</p>
 */
public abstract class CementAdapter<D> extends BaseAdapter {

    private LayoutInflater inflater;
    @Nullable
    private final AbsListView absListView;

    public CementAdapter(@Nullable AbsListView absListView) {
        this.absListView = absListView;
    }

    public CementAdapter() {
        this.absListView = null;
    }

    @SuppressWarnings("unchecked")
    @Override
    public View getView(int position, View convertView, ViewGroup parent) {

        Vu.AdapterVu<D> adapterVu;
        if (convertView == null) {
            if (inflater == null) {
                inflater = (LayoutInflater) parent.getContext()
                        .getSystemService(Context.LAYOUT_INFLATER_SERVICE);
            }

            MVP.ADAPTER mvpBinderAnn = getClass().getAnnotation(MVP.ADAPTER.class);

            Presenter presenter = getPresenter(mvpBinderAnn);

            adapterVu = getAdapterVu(position, mvpBinderAnn);

            if (adapterVu != null) {
                adapterVu.bindPresenter(presenter);
                adapterVu.bindListView(this.absListView);

                convertView = adapterVu.initView(inflater, parent);
                if (convertView != null) {
                    convertView.setTag(adapterVu);
                }
                adapterVu.onViewCreated(position);
            }
        } else {
            adapterVu = ((Vu.AdapterVu) convertView.getTag());
            adapterVu.onViewReused(position);
        }

        if (adapterVu != null) {
            adapterVu.displayDataSource(position, getDataSource(position));
        }
        return convertView;
    }

    private Vu.AdapterVu<D> getAdapterVu(int position, MVP.ADAPTER mvpBinderAnn) {
        Vu.AdapterVu<D> adapterVu = null;
        try {
            if (mvpBinderAnn != null) {
                Class<? extends Vu.AdapterVu> v = mvpBinderAnn.view();
                if (!v.getName().equals(AdapterView.class.getName())) {
                    adapterVu = v.newInstance();
                }
            }
        } catch (Exception e) {
            LogUtil.getUtils().w(e.getMessage());
        } finally {
            if (adapterVu == null) {
                adapterVu = provideVu(position);
            }
        }
        return adapterVu;
    }

    private Presenter getPresenter(MVP.ADAPTER mvpBinderAnn) {
        Presenter presenter = null;
        if (mvpBinderAnn != null) {
            if (mvpBinderAnn.presentable() && this instanceof Presenter) {
                presenter = ((Presenter) this);
            }
        }
        if (presenter == null) {
            presenter = providePresenter();
        }
        return presenter;
    }

    /**
     * 单独更新列表中的 一个视图/一条数据（单条刷新）
     *
     * @param position 视图/数据 位置
     */
    public void updateItem(int position) {

        if (this.absListView != null) {
            // 当前listView显示的第一个元素的未知
            int firstVisPosition = this.absListView.getFirstVisiblePosition();
            // 当前listView显示的最后一个元素的位置
            int lastVisPosition = this.absListView.getLastVisiblePosition();
            // 如果要更新的元素不在当前屏幕显示中，阻止界面更新操作
            if (position < firstVisPosition - 1 || position > lastVisPosition) {
                return;
            }
            // listView.getChildAt()的参数为要更新的项的索引与当前屏幕内第一条可见条目的偏移量
            View view = absListView.getChildAt(position - firstVisPosition);
            if (view != null) {
                @SuppressWarnings("unchecked")
                Vu.AdapterVu<D> vu = (Vu.AdapterVu<D>) view.getTag();
                vu.displayDataSource(position, getDataSource(position));
                vu.onViewUpdate(position);
            }
        }
    }


    /**
     * 根据位置获取数据源
     *
     * @param position 位置
     * @return 对应的数据源
     */
    public abstract D getDataSource(int position);

    @Nullable
    public Vu.AdapterVu<D> provideVu(int position) {return null;}

    @Nullable
    public Presenter providePresenter() {return null;}
}
