package com.rabbit.blade.presenter.gui.mvp.cement;

import android.support.annotation.Nullable;
import android.widget.AbsListView;

import com.rabbit.blade.presenter.gui.mvp.view.Vu;


/**
 * <b>Description : 仅仅实现了MVP绑定关系的多视图项Adapter基类</b>
 * <p>Created by <a href="mailto:fanjiandong@outlook.com">fanjiandong</a> on 2015/5/22 15:21.</p>
 */
public abstract class CementItemAdapter<D> extends CementAdapter<D> {

    public CementItemAdapter(@Nullable AbsListView absListView) {
        super(absListView);
    }

    public CementItemAdapter() {
        super();
    }

    @Nullable
    public abstract Vu.AdapterVu<D> getVuByViewType(int itemViewType);


    @Nullable
    @Override
    public Vu.AdapterVu<D> provideVu(int position) {
        int itemViewType = getItemViewType(position);
        return getVuByViewType(itemViewType);
    }
}
