package com.rabbit.blade.presenter.gui.mvp.exception;


import com.rabbit.blade.presenter.gui.mvp.presenter.Presenter;
import com.rabbit.blade.presenter.gui.mvp.view.Vu;

/**
 * <b>Description : </b>
 * <p>Created by <a href="mailto:fanjiandong@outlook.com">fanjiandong</a> on 2017/1/16 14:18.</p>
 */

public class PresenterBindException extends RuntimeException {

    public static final String MESSAGE = "Bind %s to %s Fail,please check!!!";

    public PresenterBindException(Class<? extends Presenter> presenterCls, Class<? extends Vu> vuCls) {
        super(String.format(MESSAGE, presenterCls.getCanonicalName(), vuCls.getCanonicalName()));
    }

    public PresenterBindException(Class<? extends Presenter> presenterCls, Class<? extends Vu> vuCls, Throwable cause) {
        super(String.format(MESSAGE, presenterCls.getCanonicalName(), vuCls.getCanonicalName()), cause);
    }
}
