package com.rabbit.blade.presenter.gui.mvp.presenter;

import android.support.annotation.Nullable;

import com.rabbit.blade.presenter.gui.mvp.view.Vu;


/**
 * <b>Description : Presenter接口的默认实现类</b>
 * <p>Created by <a href="mailto:fanjiandong@outlook.com">fanjiandong</a> on 2017/2/20 11:36.</p>
 */


public class ConstrainedPresenter<V extends Vu> implements Presenter {
    /**
     * View层V的接口实现对象
     */
    private V vu;

    /**
     * 获取View层V的接口实现对象
     *
     * @return View层V的接口实现对象
     */
    public V getVu() {
        return this.vu;
    }

    @Override
    public void bindVu(@Nullable Vu vi) {
        if (vi == null) {
            return;
        }
        //noinspection unchecked
        this.vu = ((V) vi);
    }
}
