package com.rabbit.blade.presenter.gui.mvp.view;

import android.app.Activity;
import android.content.Context;
import android.os.Bundle;
import android.support.annotation.LayoutRes;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.view.LayoutInflater;
import android.view.View;

import com.rabbit.blade.presenter.gui.mvp.annotation.ContentView;

import butterknife.ButterKnife;


/**
 * <b>Description : Activity中MVP范式的View层基类 </b>
 * <p>Created by <a href="mailto:fanjiandong@outlook.com">fanjiandong</a> on 2015/5/22 15:21.</p>
 */
public abstract class ActivityView implements Vu.ActivityVu {

    private Activity activity;

    @Override
    public void bindActivity(@NonNull Activity activity) {
        this.activity = activity;
    }

    @Override
    public void initView(@Nullable Bundle savedInstanceState) {

        if (this.activity != null) {
            LayoutInflater layoutInflater = this.activity.getLayoutInflater();
            int layoutRes = provideLayoutRes();
            View contentView = layoutInflater.inflate(layoutRes, null, false);
            this.activity.setContentView(contentView);
            ButterKnife.bind(this, contentView);
        }
    }

    @Override
    public void releaseView() {
        ButterKnife.unbind(this);
    }


    public Activity getActivity() {
        return this.activity;
    }

    public Context getContext() {
        return this.activity;
    }

    /**
     * 提供View相关的布局资源ID
     *
     * @return 布局资源ID
     */
    @LayoutRes
    protected int provideLayoutRes() {
        ContentView contentView = getClass().getAnnotation(ContentView.class);
        if (contentView != null) {
            return contentView.value();
        }
        return -1;
    }
}
