package com.rabbit.blade.presenter.gui.mvp.view;


import android.support.annotation.LayoutRes;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AbsListView;

import com.rabbit.blade.presenter.gui.mvp.annotation.ContentView;

import butterknife.ButterKnife;

/**
 * <b>Description : Adapter中MVP范式的View层基类</b>
 * <p>Created by <a href="mailto:fanjiandong@outlook.com">fanjiandong</a> on 2015/5/22 15:21.</p>
 */

public abstract class AdapterView<D> implements Vu.AdapterVu<D> {

    @Nullable private AbsListView absListView;

    @Nullable
    public AbsListView getAbsListView() {
        return absListView;
    }

    @Override
    public void bindListView(@Nullable AbsListView adapterView) {
        this.absListView = adapterView;
    }

    @Override
    public void onViewCreated(int position) {}

    @Override
    public void onViewReused(int position) {}

    @Override
    public void onViewUpdate(int position) {}

    @Override
    public void displayDataSource(int position, @Nullable D dataSource) {}

    @Override
    public View initView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container) {
        View contentView = inflater.inflate(provideLayoutRes(), container, false);
        ButterKnife.bind(this, contentView);
        return contentView;
    }

    /**
     * 提供View相关的布局资源ID
     *
     * @return 布局资源ID
     */
    @LayoutRes
    protected int provideLayoutRes() {
        ContentView contentView = getClass().getAnnotation(ContentView.class);
        if (contentView != null) {
            return contentView.value();
        }
        return -1;
    }
}
