package com.rabbit.blade.presenter.gui.mvp.view;

import android.app.Activity;
import android.os.Bundle;
import android.support.annotation.LayoutRes;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.app.Fragment;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;

import com.rabbit.blade.presenter.gui.mvp.annotation.ContentView;

import butterknife.ButterKnife;

/**
 * <b>Description : Activity中MVP范式的Fragment做View层基类</b>
 * <p>Created by <a href="mailto:fanjiandong@outlook.com">fanjiandong</a> on 2017/2/18 15:39.</p>
 */

public abstract class AdornFragment extends Fragment implements Vu.ActivityVu {

    private Activity activity;

    @Override
    public void bindActivity(@NonNull Activity activity) {
        this.activity = activity;
    }

    public Activity getHostActivity() {
        return this.activity;
    }

    @Nullable
    @Override
    public View onCreateView(LayoutInflater inflater,
                             @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        int layoutRes = provideLayoutRes();
        return inflater.inflate(layoutRes, container, false);
    }

    @Override
    public void onViewCreated(View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        ButterKnife.bind(this, view);
    }

    @Override
    public void onDestroyView() {
        super.onDestroyView();
        ButterKnife.unbind(this);
    }

    @Override
    public void releaseView() {}

    /**
     * 提供View相关的布局资源ID
     *
     * @return 布局资源ID
     */
    @LayoutRes
    protected int provideLayoutRes() {
        ContentView contentView = getClass().getAnnotation(ContentView.class);
        if (contentView != null) {
            return contentView.value();
        }
        return -1;
    }

}
