package com.rabbit.blade.presenter.gui.mvp.view;

import android.support.annotation.Nullable;

import com.rabbit.blade.presenter.gui.mvp.presenter.Presenter;


/**
 * <b>Description : View层接口的默认实现类</b>
 * <p>Created by <a href="mailto:fanjiandong@outlook.com">fanjiandong</a> on 2017/2/23 10:51.</p>
 */

public class ConstrainedView {

    public static class ConstrainedActivityView<P extends Presenter> extends ActivityView {

        private P presenter;

        @SuppressWarnings({"unchecked"})
        @Override
        public void bindPresenter(@Nullable Presenter presenter) {
            if (presenter == null) {
                return;
            }
            this.presenter = ((P) presenter);
        }

        public P getPresenter() {
            return presenter;
        }
    }


    public static class ConstrainedFragmentView<P extends Presenter> extends FragmentView {

        private P presenter;

        @SuppressWarnings({"unchecked"})
        @Override
        public void bindPresenter(@Nullable Presenter presenter) {
            if (presenter == null) {
                return;
            }
            this.presenter = ((P) presenter);
        }

        public P getPresenter() {
            return presenter;
        }
    }


    public static class ConstrainedAdapterView<P extends Presenter, D> extends AdapterView<D> {

        private P presenter;

        @SuppressWarnings({"unchecked"})
        @Override
        public void bindPresenter(@Nullable Presenter presenter) {
            if (presenter == null) {
                return;
            }
            this.presenter = ((P) presenter);
        }

        public P getPresenter() {
            return presenter;
        }
    }


    public abstract static class ConstrainedAdornFragment<P extends Presenter> extends AdornFragment {

        private P presenter;

        @SuppressWarnings({"unchecked"})
        @Override
        public void bindPresenter(@Nullable Presenter presenter) {
            if (presenter == null) {
                return;
            }
            this.presenter = ((P) presenter);
        }

        public P getPresenter() {
            return presenter;
        }
    }
}
