package com.rabbit.blade.presenter.gui.mvp.view;

import android.app.Activity;
import android.content.Context;
import android.os.Bundle;
import android.support.annotation.LayoutRes;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.app.Fragment;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;

import com.rabbit.blade.presenter.gui.mvp.annotation.ContentView;

import butterknife.ButterKnife;

/**
 * <b>Description : Fragment中MVP范式的View层基类</b>
 * <p>Created by <a href="mailto:fanjiandong@outlook.com">fanjiandong</a> on 2015/5/22 15:21.</p>
 */
public abstract class FragmentView implements Vu.FragmentVu {

    private Fragment fragment;

    @Override
    public void bindFragment(@NonNull Fragment fragment) {
        this.fragment = fragment;
    }

    @Override
    public View initView(
            @NonNull LayoutInflater inflater,
            @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        View contentView = inflater.inflate(provideLayoutRes(), container, false);
        ButterKnife.bind(this, contentView);
        return contentView;
    }

    @Override
    public void releaseView() {
        ButterKnife.unbind(this);
    }

    /**
     * 提供View相关的布局资源ID
     *
     * @return 布局资源ID
     */
    @LayoutRes
    protected int provideLayoutRes() {
        ContentView contentView = getClass().getAnnotation(ContentView.class);
        if (contentView != null) {
            return contentView.value();
        }
        return -1;
    }

    public Fragment getFragment() {
        return this.fragment;
    }

    public Activity getActivity() {
        if (this.fragment != null) {
            return this.fragment.getActivity();
        }
        return null;
    }

    public Context getContext() {
        return getActivity();
    }
}
