package com.rabbit.blade.presenter.main;

import android.os.Bundle;
import android.support.annotation.Nullable;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;

import com.rabbit.blade.comm.util.LogUtil;
import com.rabbit.blade.presenter.gui.mvp.annotation.MVP;
import com.rabbit.blade.presenter.gui.mvp.presenter.Presenter;
import com.rabbit.blade.presenter.gui.mvp.view.FragmentView;
import com.rabbit.blade.presenter.gui.mvp.view.Vu;


/**
 * <b>Description : 提供MVP+依赖注入的Fragment</b>
 * <p>Created by <a href="mailto:fanjiandong@outlook.com">fanjiandong</a> on 2015/5/22 15:21.</p>
 */
public class SensibleFragment extends SmartFragment {

    @Nullable
    @Override
    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {

        preMvpBinding(savedInstanceState);

        MVP.FRAGMENT mvpBinderAnn = getClass().getAnnotation(MVP.FRAGMENT.class);

        Presenter presenter = getPresenter(mvpBinderAnn);

        Vu.FragmentVu view = getFragmentVu(mvpBinderAnn);

        if (presenter != null) {
            presenter.bindVu(view);
        }

        if (view != null) {
            view.bindPresenter(presenter);
            view.bindFragment(this);
            View targetView = view.initView(inflater, container, savedInstanceState);
            afterMvpBinding(savedInstanceState);
            return targetView;
        }
        return null;
    }

    private Vu.FragmentVu getFragmentVu(MVP.FRAGMENT mvpBinderAnn) {
        Vu.FragmentVu view = null;
        try {
            if (mvpBinderAnn != null) {
                Class<? extends Vu.FragmentVu> vCls = mvpBinderAnn.view();
                if (!vCls.getName().equals(FragmentView.class.getName())) {
                    view = vCls.newInstance();
                }
            }
        } catch (Exception e) {
            LogUtil.getUtils().w(e.getMessage());
        } finally {
            if (view == null) {
                view = provideVu();
            }
        }
        return view;
    }

    private Presenter getPresenter(MVP.FRAGMENT mvpBinderAnn) {
        Presenter presenter = null;
        if (mvpBinderAnn != null) {
            if (mvpBinderAnn.presentable() && this instanceof Presenter) {
                presenter = ((Presenter) this);
            }
        }
        if (presenter == null) {
            presenter = providePresenter();
        }
        return presenter;
    }

    public void preMvpBinding(Bundle savedInstanceState) {}

    public void afterMvpBinding(Bundle savedInstanceState) {}

    @Nullable
    public Vu.FragmentVu provideVu() {return null;}

    @Nullable
    public Presenter providePresenter() {return null;}
}
