package com.rabbit.blade.presenter.main;

import android.os.Bundle;
import android.support.annotation.Nullable;
import android.support.v7.app.AppCompatActivity;
import android.text.TextUtils;

import com.rabbit.blade.comm.exeption.OkException;
import com.rabbit.blade.presenter.AndroidApplication;
import com.rabbit.blade.presenter.assist.AssistProvider;
import com.rabbit.blade.presenter.assist.Cake;
import com.rabbit.blade.presenter.assist.DialogLoader;
import com.rabbit.blade.presenter.assist.FlyHunter;
import com.rabbit.blade.presenter.assist.FlyRepo;
import com.rabbit.blade.presenter.assist.Loader;
import com.rabbit.blade.presenter.assist.ToastCake;
import com.rabbit.blade.presenter.di.components.ActivityComponent;


/**
 * <b>Description : 提供基础注入功能的Activity</b>
 * <p>Created by <a href="mailto:fanjiandong@outlook.com">fanjiandong</a> on 2017/2/10 15:30.</p>
 */
public class SmartActivity extends AppCompatActivity implements FlyHunter,AssistProvider {

    private ActivityComponent activityComponent;

    public ActivityComponent getActivityComponent() {
        if (this.activityComponent == null) {
            //初始化注入控制器
            this.activityComponent = ((AndroidApplication) getApplication())
                    .createActivityComponent(this);
        }
        return this.activityComponent;
    }

    @Override
    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);

        //通过注解定义该Activity是否入栈
        StackInto annotation = getClass().getAnnotation(StackInto.class);
        if (annotation == null || annotation.value()) {
            ActivityStack.getInstance().pushActivity(this);
        }
    }

    @Override
    protected void onDestroy() {
        this.activityComponent = null;
        ActivityStack.getInstance().popActivity(this, false);

        super.onDestroy();
    }

    @Override
    public boolean handleOkException(@Nullable String okCode,
                                     @Nullable String userMsg,
                                     @Nullable OkException ex,
                                     @Nullable String mark) {
        return false;
    }

    @Override
    public void defaultOkException(@Nullable String code,
                                   @Nullable String userMsg,
                                   @Nullable OkException ex,
                                   @Nullable String mark) {
        if (!TextUtils.isEmpty(userMsg)) {
            getActivityComponent().activityCake().showCake(userMsg);
        }
    }

    @Override
    public boolean handlerThrowable(@Nullable Throwable throwable,
                                    @Nullable String mark) {
        return false;
    }

    @Override
    public void defaultThrowable(@Nullable Throwable throwable,
                                 @Nullable String mark) {

        if (throwable == null) {
            getActivityComponent().activityCake().showCake("错误但没有提示信息,请提交错误日志！");
            return;
        }

        try {
            FlyRepo.recognizeFly(throwable);
        } catch (RuntimeException e) {
            getActivityComponent().activityCake().showCake(e.getMessage());
            return;
        }

        getActivityComponent().activityCake().showCake(throwable.getMessage());
    }

    @Override
    public Cake provideCake() {
        return new ToastCake(this);
    }

    @Override
    public FlyHunter provideFlyHunter() {
        return this;
    }

    @Override
    public Loader provideLoader() {
        return new DialogLoader(this);
    }
}
