package com.rabbit.blade.presenter.main;

import android.app.Activity;
import android.support.annotation.Nullable;
import android.support.v4.app.Fragment;
import android.text.TextUtils;

import com.rabbit.blade.comm.exeption.OkException;
import com.rabbit.blade.presenter.AndroidApplication;
import com.rabbit.blade.presenter.assist.AssistProvider;
import com.rabbit.blade.presenter.assist.Cake;
import com.rabbit.blade.presenter.assist.DialogLoader;
import com.rabbit.blade.presenter.assist.FlyHunter;
import com.rabbit.blade.presenter.assist.FlyRepo;
import com.rabbit.blade.presenter.assist.Loader;
import com.rabbit.blade.presenter.assist.ToastCake;
import com.rabbit.blade.presenter.di.components.ActivityComponent;
import com.rabbit.blade.presenter.di.components.FragmentComponent;


/**
 * <b>Description : 提供基础注入功能的Fragment</b>
 * <p>Created by <a href="mailto:fanjiandong@outlook.com">fanjiandong</a> on 2017/2/10 16:14.</p>
 */

public class SmartFragment extends Fragment implements FlyHunter,AssistProvider {

    private FragmentComponent fragmentComponent;

    public FragmentComponent getFragmentComponent() {
        if (this.fragmentComponent == null) {
            this.fragmentComponent = ((AndroidApplication) getActivity()
                    .getApplication())
                    .createFragmentComponent(this, getActivityComponent());
        }
        return this.fragmentComponent;
    }

    public ActivityComponent getActivityComponent() {
        Activity activity = getActivity();
        if (activity instanceof SmartActivity) {
            return ((SmartActivity) activity).getActivityComponent();
        } else {
            throw new IllegalStateException("the fragment's host activity is not a instance of SmartActivity");
        }
    }

    @Override
    public void onDestroy() {
        this.fragmentComponent = null;
        super.onDestroy();
    }

    @Override
    public boolean handleOkException(@Nullable String okCode,
                                     @Nullable String userMsg,
                                     @Nullable OkException ex,
                                     @Nullable String mark) {
        return false;
    }

    @Override
    public void defaultOkException(@Nullable String code,
                                   @Nullable String userMsg,
                                   @Nullable OkException ex,
                                   @Nullable String mark) {
        if (!TextUtils.isEmpty(userMsg)) {
            getFragmentComponent().fragmentCake().showCake(userMsg);
        }
    }

    @Override
    public boolean handlerThrowable(@Nullable Throwable throwable,
                                    @Nullable String mark) {
        return false;
    }

    @Override
    public void defaultThrowable(@Nullable Throwable throwable,
                                 @Nullable String mark) {

        if (throwable == null) {
            getFragmentComponent().fragmentCake().showCake("错误但没有提示信息,请提交错误日志！");
            return;
        }

        try {
            FlyRepo.recognizeFly(throwable);
        } catch (RuntimeException e) {
            getFragmentComponent().fragmentCake().showCake(e.getMessage());
            return;
        }

        getFragmentComponent().fragmentCake().showCake(throwable.getMessage());
    }

    @Override
    public Cake provideCake() {
        return new ToastCake(getActivity());
    }

    @Override
    public FlyHunter provideFlyHunter() {
        return this;
    }

    @Override
    public Loader provideLoader() {
        return new DialogLoader(getActivity());
    }
}
