/*
 * Decompiled with CFR 0.152.
 */
package com.rabbit.blade.presenter.main;

import android.app.Activity;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.rabbit.blade.presenter.main.SmartActivity;
import java.util.Iterator;
import java.util.LinkedList;

public class ActivityStack {
    @Nullable
    private static ActivityStack instance;
    private final LinkedList<SmartActivity> activities = new LinkedList();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @NonNull
    public static ActivityStack getInstance() {
        if (instance != null) return instance;
        Class<ActivityStack> clazz = ActivityStack.class;
        synchronized (ActivityStack.class) {
            if (instance != null) return instance;
            instance = new ActivityStack();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    private ActivityStack() {
    }

    @NonNull
    public LinkedList<SmartActivity> getAllActivities() {
        return this.activities;
    }

    @Nullable
    public SmartActivity getTopActivity() {
        if (this.activities.isEmpty()) {
            return null;
        }
        return this.activities.getFirst();
    }

    public void pushActivity(@NonNull SmartActivity activity) {
        this.activities.addFirst(activity);
    }

    public boolean popActivity(@NonNull SmartActivity activity, boolean isFinish) {
        if (this.activities.isEmpty()) {
            return false;
        }
        if (this.activities.contains(activity)) {
            if (isFinish) {
                activity.finish();
            }
            return this.activities.remove(activity);
        }
        return false;
    }

    public void popAllActivities(boolean isFinish) {
        if (this.activities.isEmpty()) {
            return;
        }
        if (isFinish) {
            Iterator iterator = this.activities.iterator();
            while (iterator.hasNext()) {
                ((SmartActivity)iterator.next()).finish();
            }
        }
        this.activities.clear();
    }

    public void popActivitiesUntil(int position, boolean isFinish) {
        if (this.activities.isEmpty() || position < 0) {
            return;
        }
        for (int i = 0; i < position; ++i) {
            if (isFinish) {
                this.activities.getFirst().finish();
            }
            this.activities.removeFirst();
        }
    }

    public void popActivitiesUntil(@NonNull SmartActivity activity, boolean isFinish) {
        if (this.activities.isEmpty() || !this.activities.contains(activity)) {
            return;
        }
        int position = this.activities.indexOf(activity) - 1;
        this.popActivitiesUntil(position, isFinish);
    }

    public void pop2TopActivity(boolean isFinish) {
        int position = this.activities.size() - 1;
        for (int i = 0; i < position; ++i) {
            if (isFinish) {
                this.activities.getLast().finish();
            }
            this.activities.removeLast();
        }
    }

    public <T extends Activity> void popActivitiesUntil(@NonNull Class<T> cls, boolean isFinish) {
        if (this.activities.isEmpty()) {
            return;
        }
        int position = -1;
        for (int i = 0; i < this.activities.size(); ++i) {
            if (!this.activities.get(i).getClass().equals(cls)) continue;
            position = i;
            break;
        }
        this.popActivitiesUntil(position, isFinish);
    }

    public void exitApp() {
        this.popAllActivities(true);
    }

    @Nullable
    public SmartActivity getActivityByClassName(@NonNull String activityName) {
        if (this.activities.isEmpty()) {
            return null;
        }
        for (SmartActivity ac : this.activities) {
            if (!ac.getClass().getName().equals(activityName)) continue;
            return ac;
        }
        return null;
    }

    @Nullable
    public SmartActivity getActivityByClass(Class<? extends SmartActivity> cs) {
        if (this.activities.isEmpty()) {
            return null;
        }
        for (SmartActivity ac : this.activities) {
            if (!ac.getClass().equals(cs)) continue;
            return ac;
        }
        return null;
    }
}

