/*
 * Decompiled with CFR 0.152.
 */
package com.rabbit.blade.presenter;

import android.content.res.Configuration;
import android.support.annotation.Nullable;
import com.rabbit.blade.presenter.BoundedAppProvider;
import com.rabbit.blade.presenter.BoundedApplication;
import com.rabbit.blade.presenter.ComponentApplication;
import java.util.ArrayList;
import java.util.List;

public abstract class ForkedApplication
extends ComponentApplication {
    private List<BoundedApplication> boundedApplications;

    @Nullable
    public <T extends BoundedApplication> T getBoundedApp(Class<T> appCls) {
        if (this.boundedApplications != null && !this.boundedApplications.isEmpty()) {
            for (BoundedApplication cycle : this.boundedApplications) {
                if (cycle == null || !cycle.getClass().getName().equals(appCls.getName())) continue;
                return (T)((BoundedApplication)appCls.cast(cycle));
            }
        }
        return null;
    }

    private List<BoundedApplication> initBoundedApps(List<BoundedAppProvider> boundedAppProviders) {
        if (boundedAppProviders != null && !boundedAppProviders.isEmpty()) {
            ArrayList<BoundedApplication> boundedApplications = new ArrayList<BoundedApplication>();
            for (BoundedAppProvider provider : boundedAppProviders) {
                boundedApplications.addAll(provider.provideBoundedApplications());
            }
            return boundedApplications;
        }
        return null;
    }

    @Nullable
    public abstract List<BoundedAppProvider> buildBoundedAppGraph();

    public abstract void afterAppsBounded();

    public void onApplicationCreate() {
        if (this.boundedApplications != null && !this.boundedApplications.isEmpty()) {
            for (BoundedApplication cycle : this.boundedApplications) {
                cycle.onCreate(this);
            }
        }
    }

    public void onCreate() {
        super.onCreate();
        this.boundedApplications = this.initBoundedApps(this.buildBoundedAppGraph());
        this.afterAppsBounded();
        this.onApplicationCreate();
    }

    public void onTerminate() {
        super.onTerminate();
        if (this.boundedApplications != null && !this.boundedApplications.isEmpty()) {
            for (BoundedApplication cycle : this.boundedApplications) {
                cycle.onTerminate();
            }
        }
    }

    public void onConfigurationChanged(Configuration newConfig) {
        super.onConfigurationChanged(newConfig);
        if (this.boundedApplications != null && !this.boundedApplications.isEmpty()) {
            for (BoundedApplication cycle : this.boundedApplications) {
                cycle.onConfigurationChanged(newConfig);
            }
        }
    }

    public void onLowMemory() {
        super.onLowMemory();
        if (this.boundedApplications != null && !this.boundedApplications.isEmpty()) {
            for (BoundedApplication cycle : this.boundedApplications) {
                cycle.onLowMemory();
            }
        }
    }

    public void onTrimMemory(int level) {
        super.onTrimMemory(level);
        if (this.boundedApplications != null && !this.boundedApplications.isEmpty()) {
            for (BoundedApplication cycle : this.boundedApplications) {
                cycle.onTrimMemory(level);
            }
        }
    }
}

