/*
 * Decompiled with CFR 0.152.
 */
package com.rabbit.blade.presenter.assist;

import android.content.DialogInterface;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.rabbit.blade.comm.exeption.OkException;
import com.rabbit.blade.comm.exeption.OkMatcher;
import com.rabbit.blade.presenter.assist.Loader;
import com.rabbit.blade.presenter.assist.OkSubscriber;
import com.rabbit.blade.presenter.assist.PlanFly;
import rx.Subscriber;
import rx.functions.Action1;

public class SchSubscriber<T>
extends OkSubscriber<T> {
    private static final String PRE_LOADING_MSG = "\u6b63\u5728";
    private static final String DEFAULT_LOADING_MSG = "\u52a0\u8f7d";
    private static final String AFTER_LOADING_MSG = "...";
    private String loadingMessage = "\u52a0\u8f7d";
    private boolean isLoading = true;
    private final Loader loader;
    private boolean cancelable = true;
    private DialogInterface.OnCancelListener onCancelListener;

    public SchSubscriber(@Nullable PlanFly planFly, @Nullable Loader loader, @Nullable String mark) {
        super(planFly, mark);
        this.loader = loader;
    }

    public SchSubscriber(@Nullable PlanFly planFly, @Nullable Loader loader) {
        this(planFly, loader, null);
    }

    public SchSubscriber<T> setLoading(boolean loading) {
        this.isLoading = loading;
        return this;
    }

    public SchSubscriber<T> registerLoadingMsg(@NonNull String loadingMsg) {
        return this.registerLoadingMsg(loadingMsg, true);
    }

    public SchSubscriber<T> registerLoadingMsg(@NonNull String loadingMsg, boolean isAutoAdd) {
        this.loadingMessage = isAutoAdd ? PRE_LOADING_MSG + loadingMsg + AFTER_LOADING_MSG : loadingMsg;
        return this;
    }

    public SchSubscriber<T> setCancelable(boolean isCancelable) {
        this.cancelable = isCancelable;
        return this;
    }

    public SchSubscriber<T> setCancelListener(DialogInterface.OnCancelListener cancelListener) {
        this.onCancelListener = cancelListener;
        return this;
    }

    public <T1 extends OkException> SchSubscriber<T> registUserMsg(@NonNull Class<T1> cls, @NonNull String errorCode, @NonNull String userMsg, boolean isClearPreMsg) {
        OkMatcher matcher;
        if (this.getPlanFly() != null && (matcher = this.getPlanFly().getMatcher()) != null) {
            if (isClearPreMsg) {
                matcher.getCustomMapper().reset();
            }
            matcher.getCustomMapper().registSingleMapper(cls, errorCode, userMsg);
        }
        return this;
    }

    public void onStart() {
        super.onStart();
        this.showLoading();
    }

    @Override
    public void onError(Throwable e) {
        super.onError(e);
        this.dismissDialog();
    }

    @Override
    public void onCompleted() {
        super.onCompleted();
        this.dismissDialog();
    }

    private void showLoading() {
        if (this.loadingMessage.equals(DEFAULT_LOADING_MSG)) {
            this.loadingMessage = PRE_LOADING_MSG + this.loadingMessage + AFTER_LOADING_MSG;
        }
        this.showLoadingDialog();
    }

    private void showLoadingDialog() {
        if (!this.isLoading) {
            return;
        }
        if (this.loader != null) {
            this.loader.loadingMessage(this.loadingMessage, this.cancelable, this.onCancelListener);
        }
    }

    private void dismissDialog() {
        if (!this.isLoading) {
            return;
        }
        if (this.loader != null) {
            this.loader.cancel();
        }
    }

    public static class Builder<T> {
        private String loadingMessage = "\u52a0\u8f7d";
        private boolean isLoading = true;
        private boolean cancelable = true;
        private Loader loader;
        private DialogInterface.OnCancelListener onCancelListener;
        private String mark;
        private PlanFly planFly;
        private boolean isAutoCompleteLoadingMessage = true;
        private Subscriber<T> subscriber;
        private Object[] userMessageArray;

        public Builder<T> planFly(@Nullable PlanFly planFly) {
            this.planFly = planFly;
            return this;
        }

        public Builder<T> loadingMessage(@NonNull String loadingMessage) {
            this.loadingMessage = loadingMessage;
            return this;
        }

        public Builder<T> showLoading(boolean isLoading) {
            this.isLoading = isLoading;
            return this;
        }

        public Builder<T> cancelable(boolean cancelable) {
            this.cancelable = cancelable;
            return this;
        }

        public Builder<T> cancelListener(DialogInterface.OnCancelListener cancelListener) {
            this.onCancelListener = cancelListener;
            return this;
        }

        public Builder<T> loader(@Nullable Loader loader) {
            this.loader = loader;
            return this;
        }

        public Builder<T> mark(@Nullable String mark) {
            this.mark = mark;
            return this;
        }

        public Builder<T> isAutoCompleteLoadingMessage(boolean isAutoCompleteLoadingMessage) {
            this.isAutoCompleteLoadingMessage = isAutoCompleteLoadingMessage;
            return this;
        }

        public Builder<T> subscriber(Subscriber<T> subscriber) {
            this.subscriber = subscriber;
            return this;
        }

        public Builder<T> action(final Action1<T> action0) {
            this.subscriber = new Subscriber<T>(){

                public void onCompleted() {
                }

                public void onError(Throwable e) {
                }

                public void onNext(T t) {
                    action0.call(t);
                }
            };
            return this;
        }

        public <T1 extends OkException> Builder<T> registUserMessage(@NonNull Class<T1> cls, @NonNull String errorCode, @NonNull String userMsg, boolean isClearPreMsg) {
            this.userMessageArray = new Object[4];
            this.userMessageArray[0] = cls;
            this.userMessageArray[1] = errorCode;
            this.userMessageArray[2] = userMsg;
            this.userMessageArray[3] = isClearPreMsg;
            return this;
        }

        public SchSubscriber<T> build() {
            SchSubscriber schSubscriber = new SchSubscriber<T>(this.planFly, this.loader, this.mark){

                @Override
                public void onNext(T t) {
                    super.onNext(t);
                    if (Builder.this.subscriber != null) {
                        Builder.this.subscriber.onNext(t);
                    }
                }

                @Override
                public void onStart() {
                    super.onStart();
                    if (Builder.this.subscriber != null) {
                        Builder.this.subscriber.onStart();
                    }
                }

                @Override
                public void onError(Throwable e) {
                    super.onError(e);
                    if (Builder.this.subscriber != null) {
                        Builder.this.subscriber.onError(e);
                    }
                }

                @Override
                public void onCompleted() {
                    super.onCompleted();
                    if (Builder.this.subscriber != null) {
                        Builder.this.subscriber.onCompleted();
                    }
                }
            };
            schSubscriber.setLoading(this.isLoading);
            if (this.isLoading) {
                schSubscriber.registerLoadingMsg(this.loadingMessage, this.isAutoCompleteLoadingMessage);
            }
            schSubscriber.setCancelable(this.cancelable);
            if (this.cancelable && this.onCancelListener != null) {
                schSubscriber.setCancelListener(this.onCancelListener);
            }
            if (this.userMessageArray != null) {
                schSubscriber.registUserMsg((Class)this.userMessageArray[0], (String)this.userMessageArray[1], (String)this.userMessageArray[2], (Boolean)this.userMessageArray[3]);
            }
            return schSubscriber;
        }
    }
}

