/*
 * Decompiled with CFR 0.152.
 */
package com.rabbit.blade.presenter.di.modules;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.rabbit.blade.comm.annotation.qua.AroundQua;
import com.rabbit.blade.comm.annotation.scop.PerActivity;
import com.rabbit.blade.presenter.assist.AssistProvider;
import com.rabbit.blade.presenter.assist.Cake;
import com.rabbit.blade.presenter.assist.FlyHunter;
import com.rabbit.blade.presenter.assist.Loader;
import com.rabbit.blade.presenter.di.components.FragmentComponent;
import com.rabbit.blade.presenter.main.SmartActivity;
import dagger.Module;
import dagger.Provides;

@Module(subcomponents={FragmentComponent.class})
public class ActivityModule {
    private final SmartActivity smartActivity;

    public ActivityModule(@NonNull SmartActivity smartActivity) {
        this.smartActivity = smartActivity;
    }

    @Provides
    @PerActivity
    @AroundQua(value="qua_activity")
    Activity provideActivity() {
        return this.smartActivity;
    }

    @Provides
    @PerActivity
    @AroundQua(value="qua_activity")
    Context provideContext() {
        return this.smartActivity;
    }

    @Provides
    @PerActivity
    Intent provideIntent() {
        return this.smartActivity.getIntent();
    }

    @Provides
    @PerActivity
    @AroundQua(value="qua_activity")
    @Nullable
    Bundle provideBundle(Intent intent) {
        return intent.getExtras();
    }

    @Provides
    @PerActivity
    @AroundQua(value="qua_activity")
    AssistProvider provideAssist() {
        return this.smartActivity;
    }

    @Provides
    @PerActivity
    @AroundQua(value="qua_activity")
    Loader provideLoader(@AroundQua(value="qua_activity") AssistProvider assistProvider) {
        return assistProvider.provideLoader();
    }

    @Provides
    @PerActivity
    @AroundQua(value="qua_activity")
    Cake provideCake(@AroundQua(value="qua_activity") AssistProvider assistProvider) {
        return assistProvider.provideCake();
    }

    @Provides
    @PerActivity
    @AroundQua(value="qua_activity")
    FlyHunter provideFlyHunter(@AroundQua(value="qua_activity") AssistProvider assistProvider) {
        return assistProvider.provideFlyHunter();
    }

    public static interface Provider {
        @AroundQua(value="qua_activity")
        public Activity activity();

        @AroundQua(value="qua_activity")
        public Context activityContext();

        public Intent intent();

        @Nullable
        @AroundQua(value="qua_activity")
        public Bundle activityBundle();

        @AroundQua(value="qua_activity")
        public AssistProvider activityAssist();

        @AroundQua(value="qua_activity")
        public Loader activityLoader();

        @AroundQua(value="qua_activity")
        public Cake activityCake();

        @Nullable
        @AroundQua(value="qua_activity")
        public FlyHunter activityFlyHunter();
    }
}

