/*
 * Decompiled with CFR 0.152.
 */
package com.rabbit.blade.presenter.di.modules;

import android.app.Activity;
import android.content.Context;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.app.Fragment;
import com.rabbit.blade.comm.annotation.qua.AroundQua;
import com.rabbit.blade.comm.annotation.scop.PerFragment;
import com.rabbit.blade.presenter.assist.AssistProvider;
import com.rabbit.blade.presenter.assist.Cake;
import com.rabbit.blade.presenter.assist.FlyHunter;
import com.rabbit.blade.presenter.assist.Loader;
import com.rabbit.blade.presenter.main.SmartFragment;
import dagger.Module;
import dagger.Provides;

@Module
public class FragmentModule {
    private final SmartFragment smartFragment;

    public FragmentModule(@NonNull SmartFragment smartFragment) {
        this.smartFragment = smartFragment;
    }

    @Provides
    @PerFragment
    Fragment provideFragment() {
        return this.smartFragment;
    }

    @Provides
    @PerFragment
    @AroundQua(value="qua_fragment")
    Bundle provideBundle() {
        return this.smartFragment.getArguments();
    }

    @Provides
    @PerFragment
    @AroundQua(value="qua_fragment")
    Context provideContext() {
        return this.smartFragment.getContext();
    }

    @Provides
    @PerFragment
    @AroundQua(value="qua_fragment")
    Activity provideActivity() {
        return this.smartFragment.getActivity();
    }

    @Provides
    @PerFragment
    @AroundQua(value="qua_fragment")
    AssistProvider provideAssist() {
        return this.smartFragment;
    }

    @Provides
    @PerFragment
    @AroundQua(value="qua_fragment")
    Loader provideLoader(@AroundQua(value="qua_fragment") AssistProvider assistProvider) {
        return assistProvider.provideLoader();
    }

    @Provides
    @PerFragment
    @AroundQua(value="qua_fragment")
    Cake provideCake(@AroundQua(value="qua_fragment") AssistProvider assistProvider) {
        return assistProvider.provideCake();
    }

    @Provides
    @PerFragment
    @AroundQua(value="qua_fragment")
    FlyHunter provideFlyHunter(@AroundQua(value="qua_fragment") AssistProvider assistProvider) {
        return assistProvider.provideFlyHunter();
    }

    public static interface Provider {
        public Fragment fragment();

        @AroundQua(value="qua_fragment")
        public Activity activity4Fragment();

        @AroundQua(value="qua_fragment")
        public Context fragmentContext();

        @AroundQua(value="qua_fragment")
        public Bundle fragmentBundle();

        @AroundQua(value="qua_fragment")
        public AssistProvider fragmentAssist();

        @AroundQua(value="qua_fragment")
        public Loader fragmentLoader();

        @AroundQua(value="qua_fragment")
        public Cake fragmentCake();

        @Nullable
        @AroundQua(value="qua_fragment")
        public FlyHunter fragmentFlyHunter();
    }
}

