/*
 * Decompiled with CFR 0.152.
 */
package com.rabbit.blade.presenter;

import android.app.Activity;
import android.app.Application;
import android.content.Context;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.blankj.utilcode.utils.Utils;
import com.rabbit.blade.comm.BuildConfig;
import com.rabbit.blade.comm.exeption.OkException;
import com.rabbit.blade.presenter.ForkedApplication;
import com.rabbit.blade.presenter.assist.AssistProvider;
import com.rabbit.blade.presenter.assist.Cake;
import com.rabbit.blade.presenter.assist.FlyHunter;
import com.rabbit.blade.presenter.assist.Loader;
import com.rabbit.blade.presenter.assist.ToastCake;
import com.rabbit.blade.presenter.di.components.ActivityComponent;
import com.rabbit.blade.presenter.di.components.ApplicationComponent;
import com.rabbit.blade.presenter.di.components.DaggerApplicationComponent;
import com.rabbit.blade.presenter.di.components.FragmentComponent;
import com.rabbit.blade.presenter.di.modules.ActivityModule;
import com.rabbit.blade.presenter.di.modules.ApplicationModule;
import com.rabbit.blade.presenter.di.modules.EventModule;
import com.rabbit.blade.presenter.di.modules.ExecutorModule;
import com.rabbit.blade.presenter.di.modules.FragmentModule;
import com.rabbit.blade.presenter.di.modules.NetworkModule;
import com.rabbit.blade.presenter.di.modules.UtilModule;
import com.rabbit.blade.presenter.main.ActivityStack;
import com.rabbit.blade.presenter.main.SmartActivity;
import com.rabbit.blade.presenter.main.SmartFragment;

public abstract class AndroidApplication
extends ForkedApplication
implements FlyHunter,
AssistProvider {
    public static final String COMTAG_APPLICATION_COMPONENT = "applicationComponent";

    public ApplicationComponent getApplicationComponent() {
        ApplicationComponent applicationComponent = (ApplicationComponent)this.getComponent(COMTAG_APPLICATION_COMPONENT);
        if (applicationComponent == null) {
            applicationComponent = this.createApplicationComponent();
            this.registComponent(COMTAG_APPLICATION_COMPONENT, applicationComponent);
        }
        return applicationComponent;
    }

    @Override
    public void onCreate() {
        Utils.init((Context)this);
        this.registerActivityLifecycleCallbacks(new Application.ActivityLifecycleCallbacks(){

            public void onActivityCreated(Activity activity, Bundle savedInstanceState) {
                ActivityStack.getInstance().pushActivity(activity);
            }

            public void onActivityStarted(Activity activity) {
            }

            public void onActivityResumed(Activity activity) {
            }

            public void onActivityPaused(Activity activity) {
            }

            public void onActivityStopped(Activity activity) {
            }

            public void onActivitySaveInstanceState(Activity activity, Bundle outState) {
            }

            public void onActivityDestroyed(Activity activity) {
                ActivityStack.getInstance().popActivity(activity, false);
            }
        });
        super.onCreate();
    }

    private ApplicationComponent createApplicationComponent() {
        return DaggerApplicationComponent.builder().applicationModule(new ApplicationModule(this)).utilModule(new UtilModule()).networkModule(new NetworkModule(BuildConfig.DEBUG)).executorModule(new ExecutorModule()).eventModule(new EventModule()).build();
    }

    public ActivityComponent createActivityComponent(@NonNull SmartActivity activity) {
        return this.getApplicationComponent().activityComponentBuilder().activityModule(new ActivityModule(activity)).build();
    }

    public FragmentComponent createFragmentComponent(@NonNull SmartFragment fragment, @NonNull ActivityComponent activityComponent) {
        return activityComponent.fragmentComponentBuilder().fragmentModule(new FragmentModule(fragment)).build();
    }

    @Override
    public boolean handleOkException(@Nullable String okCode, @Nullable String userMsg, @Nullable OkException ex, @Nullable String mark) {
        return false;
    }

    @Override
    public void defaultOkException(@Nullable String code, @Nullable String userMsg, @Nullable OkException ex, @Nullable String mark) {
    }

    @Override
    public boolean handlerThrowable(@Nullable Throwable throwable, @Nullable String mark) {
        return false;
    }

    @Override
    public void defaultThrowable(@Nullable Throwable throwable, @Nullable String mark) {
    }

    @Override
    public Cake provideCake() {
        return new ToastCake((Context)this);
    }

    @Override
    public FlyHunter provideFlyHunter() {
        return this;
    }

    @Override
    public Loader provideLoader() {
        ActivityComponent activityComponent;
        Activity topActivity = ActivityStack.getInstance().getTopActivity();
        if (topActivity != null && topActivity instanceof SmartActivity && (activityComponent = ((SmartActivity)topActivity).getActivityComponent()) != null) {
            return activityComponent.activityLoader();
        }
        return null;
    }
}

