/*
 * Decompiled with CFR 0.152.
 */
package com.rabbit.blade.presenter;

import android.content.Context;
import android.content.res.Configuration;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import com.rabbit.blade.presenter.BoundedAppProvider;
import com.rabbit.blade.presenter.BoundedApplication;
import com.rabbit.blade.presenter.BoundedApplicationConfig;
import com.rabbit.blade.presenter.ComponentApplication;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class ForkedApplication
extends ComponentApplication {
    private static final String LC_ONCREATE = "onCreate";
    private static final String LC_ONTERMINATE = "onTerminate";
    private static final String LC_ONCONFIGURATIONCHANGED = "onConfigurationChanged";
    private static final String LC_ONLOWMEMORY = "onLowMemory";
    private static final String LC_ONTRIMMEMORY = "onTrimMemory";
    private static final String LC_ONDESTROY = "onDestroy";
    private LinkedHashMap<String, BoundedApplication> boundedApplications;

    @Nullable
    public abstract List<BoundedAppProvider> buildBoundedAppGraph();

    public abstract void afterForkedApplicationsBounded();

    public abstract void preForkedApplicationsBounded();

    public void onCreate() {
        super.onCreate();
        this.preForkedApplicationsBounded();
        this.initForkedApplications();
        this.afterForkedApplicationsBounded();
        this.performLifeCycle(LC_ONCREATE, null);
    }

    public void onTerminate() {
        super.onTerminate();
        this.performLifeCycle(LC_ONTERMINATE, null);
    }

    public void onConfigurationChanged(Configuration newConfig) {
        super.onConfigurationChanged(newConfig);
        this.performLifeCycle(LC_ONCONFIGURATIONCHANGED, newConfig);
    }

    public void onLowMemory() {
        super.onLowMemory();
        this.performLifeCycle(LC_ONLOWMEMORY, null);
    }

    public void onTrimMemory(int level) {
        super.onTrimMemory(level);
        this.performLifeCycle(LC_ONTRIMMEMORY, level);
    }

    @Nullable
    public <T extends BoundedApplication> T getForkedApplication(@NonNull String tag) {
        if (this.boundedApplications != null && !this.boundedApplications.isEmpty()) {
            return (T)this.boundedApplications.get(tag);
        }
        return null;
    }

    private void initForkedApplications() {
        ArrayList<BoundedApplicationConfig> configs = null;
        List<BoundedAppProvider> boundedAppProviders = this.buildBoundedAppGraph();
        if (boundedAppProviders != null && !boundedAppProviders.isEmpty()) {
            configs = new ArrayList<BoundedApplicationConfig>();
            for (BoundedAppProvider provider : boundedAppProviders) {
                if (provider == null || provider.provideBoundedApplications() == null) continue;
                configs.addAll(provider.provideBoundedApplications());
            }
        }
        if (configs != null && !configs.isEmpty()) {
            Collections.sort(configs);
            this.boundedApplications = new LinkedHashMap();
            for (BoundedApplicationConfig config : configs) {
                if (config == null) continue;
                String tag = config.getTag();
                BoundedApplication boundedApplication = config.getBoundedApplication();
                if (TextUtils.isEmpty((CharSequence)tag) || boundedApplication == null) {
                    throw new RuntimeException("BoundedApplicationConfig not valid,please check");
                }
                this.boundedApplications.put(tag, boundedApplication);
            }
        }
    }

    public void performLifeCycle(String lc, @Nullable Object arg) {
        if (this.boundedApplications == null || this.boundedApplications.isEmpty()) {
            return;
        }
        Set<Map.Entry<String, BoundedApplication>> entries = this.boundedApplications.entrySet();
        for (Map.Entry<String, BoundedApplication> entry : entries) {
            if (entry == null || entry.getValue() == null) continue;
            BoundedApplication boundedApplication = entry.getValue();
            switch (lc) {
                case "onCreate": {
                    boundedApplication.onCreate(this);
                    break;
                }
                case "onTerminate": {
                    boundedApplication.onTerminate();
                    break;
                }
                case "onConfigurationChanged": {
                    if (arg == null) break;
                    boundedApplication.onConfigurationChanged((Configuration)arg);
                    break;
                }
                case "onLowMemory": {
                    boundedApplication.onLowMemory();
                    break;
                }
                case "onTrimMemory": {
                    if (arg == null) break;
                    boundedApplication.onTrimMemory((Integer)arg);
                    break;
                }
                case "onDestroy": {
                    boundedApplication.onDestroy();
                    break;
                }
            }
        }
    }

    @Nullable
    public static <T extends BoundedApplication> T getForkedApplication(@NonNull Context context, @NonNull String appTag) {
        Context applicationContext = context.getApplicationContext();
        if (applicationContext instanceof ForkedApplication) {
            ForkedApplication forkedApplication = (ForkedApplication)applicationContext;
            return forkedApplication.getForkedApplication(appTag);
        }
        return null;
    }
}

