/*
 * Decompiled with CFR 0.152.
 */
package com.rabbit.blade.presenter.di.modules;

import android.app.ActivityManager;
import android.app.AlarmManager;
import android.app.NotificationManager;
import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.view.LayoutInflater;
import com.rabbit.blade.comm.annotation.qua.AroundQua;
import com.rabbit.blade.presenter.AndroidApplication;
import com.rabbit.blade.presenter.assist.AssistProvider;
import com.rabbit.blade.presenter.assist.Cake;
import com.rabbit.blade.presenter.assist.FlyHunter;
import com.rabbit.blade.presenter.assist.Loader;
import com.rabbit.blade.presenter.di.components.ActivityComponent;
import dagger.Module;
import dagger.Provides;
import javax.inject.Singleton;

@Module(subcomponents={ActivityComponent.class})
public class ApplicationModule {
    private final AndroidApplication application;

    public ApplicationModule(@NonNull AndroidApplication application) {
        this.application = application;
    }

    @Provides
    @Singleton
    @AroundQua(value="qua_application")
    Context provideApplicationContext() {
        return this.application;
    }

    @Provides
    @Singleton
    LayoutInflater provideLayoutInflater() {
        return LayoutInflater.from((Context)this.application);
    }

    @Singleton
    @Provides
    ActivityManager provideActivityManager() {
        return (ActivityManager)this.application.getSystemService("activity");
    }

    @Singleton
    @Provides
    AlarmManager provideAlarmManager() {
        return (AlarmManager)this.application.getSystemService("alarm");
    }

    @Singleton
    @Provides
    NotificationManager provideNotificationManager() {
        return (NotificationManager)this.application.getSystemService("notification");
    }

    @Singleton
    @Provides
    @AroundQua(value="qua_application")
    AssistProvider provideAssist() {
        return this.application;
    }

    @Singleton
    @Provides
    @AroundQua(value="qua_application")
    Cake provideCake(@AroundQua(value="qua_application") AssistProvider assistProvider) {
        return assistProvider.provideCake();
    }

    @Provides
    @Singleton
    @AroundQua(value="qua_application")
    @Nullable
    Loader provideLoader(@AroundQua(value="qua_application") AssistProvider assistProvider) {
        return assistProvider.provideLoader();
    }

    @Singleton
    @Provides
    @AroundQua(value="qua_application")
    FlyHunter provideFlyHunter(@AroundQua(value="qua_application") AssistProvider assistProvider) {
        return assistProvider.provideFlyHunter();
    }

    public static interface Provider {
        @AroundQua(value="qua_application")
        public Context applicationContext();

        public LayoutInflater layoutInflater();

        public ActivityManager activityManager();

        public AlarmManager alarmManager();

        public NotificationManager notificationmanager();

        @AroundQua(value="qua_application")
        public AssistProvider applicationAssist();

        @AroundQua(value="qua_application")
        public Cake applicationCake();

        @AroundQua(value="qua_application")
        @Nullable
        public Loader applicationLoader();

        @AroundQua(value="qua_application")
        public FlyHunter applicationFlyHunter();
    }
}

