/*
 * Decompiled with CFR 0.152.
 */
package com.rabbit.blade.presenter.di.modules;

import android.content.Context;
import com.google.gson.Gson;
import com.rabbit.blade.comm.annotation.qua.AroundQua;
import com.rabbit.blade.data.cache.ConfigCache;
import com.rabbit.blade.data.cache.ConfigCacheImpl;
import com.rabbit.blade.data.persistent.PreferencesEditor;
import com.rabbit.blade.data.remedy.RemedyCache;
import com.rabbit.blade.data.remedy.RemedyCacheImpl;
import dagger.Module;
import dagger.Provides;
import javax.inject.Singleton;

@Module
public class UtilModule {
    @Singleton
    @Provides
    Gson provideGson() {
        return new Gson();
    }

    @Singleton
    @Provides
    ConfigCache provideDefaultConfigCache(ConfigCacheImpl imp) {
        return imp;
    }

    @Singleton
    @Provides
    RemedyCache provideRemedyCache(@AroundQua(value="qua_application") Context context, Gson gson) {
        PreferencesEditor util = new PreferencesEditor(context, "remedies");
        return new RemedyCacheImpl(util, gson);
    }

    @Singleton
    @Provides
    PreferencesEditor providePreferencesEditor(@AroundQua(value="qua_application") Context aContext) {
        return new PreferencesEditor(aContext);
    }

    public static interface Provider {
        public Gson gson();

        public ConfigCache defaultConfigCache();

        public RemedyCache remedyCache();

        public PreferencesEditor defaultPreferencesEditor();
    }
}

